/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateDetailModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateDetailCountRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateDetailSumRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IRebateDetailService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.gateway.OrganizationGateway;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RebateDetailDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RebateDetailEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.StdOrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.StdRebateDetailEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RebateDetailServiceImpl
implements IRebateDetailService {
    private static final Logger logger = LoggerFactory.getLogger(RebateDetailServiceImpl.class);
    @Resource
    private RebateDetailDas rebateDetailDas;
    @Resource
    private OrderDas orderDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private OrganizationGateway organizationGateway;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addRebateDetail(RebateDetailAddReqDto reqDto) {
        RebateDetailEo rebateDetailEo = new RebateDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rebateDetailEo);
        this.rebateDetailDas.insert((BaseEo)rebateDetailEo);
        return rebateDetailEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyRebateDetail(RebateDetailModifyReqDto reqDto) {
        RebateDetailEo rebateDetailEo = new RebateDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rebateDetailEo);
        this.rebateDetailDas.updateSelective((BaseEo)rebateDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRebateDetail(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.rebateDetailDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public RebateDetailRespDto queryRebateDetailById(Long id) {
        RebateDetailEo rebateDetailEo = (RebateDetailEo)this.rebateDetailDas.selectByPrimaryKey(id);
        if (rebateDetailEo == null) {
            return null;
        }
        RebateDetailRespDto rebateDetailRespDto = new RebateDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)rebateDetailEo, (BaseVo)rebateDetailRespDto);
        return rebateDetailRespDto;
    }

    @Override
    public PageInfo<RebateDetailRespDto> queryRebateDetailByPage(RebateDetailQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        RebateDetailEo rebateDetailEo = this.getRebateDetailEo(reqDto);
        PageInfo eoPageInfo = this.rebateDetailDas.selectPage((BaseEo)rebateDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, RebateDetailRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            List customerIds = dtoList.stream().map(RebateDetailRespDto::getUserId).distinct().collect(Collectors.toList());
            RestResponse customerRespDtoResponse = this.customerExtQueryApi.queryListByCustomerIds(customerIds);
            List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)customerRespDtoResponse);
            Map<Long, Long> customerIdMerchantOrgIdMap = customerRespDtoList.stream().collect(Collectors.toMap(BaseRespDto::getId, CustomerRespDto::getMerchantId));
            dtoList.forEach(bean -> {
                RestResponse OrgAndOrgInfoRespDtoRestResponse = this.organizationQueryApi.queryOrgAndOrgInfo((Long)customerIdMerchantOrgIdMap.get(bean.getUserId()));
                OrgAndOrgInfoRespDto OrgAndOrgInfoRespDto2 = (OrgAndOrgInfoRespDto)RestResponseHelper.extractData((RestResponse)OrgAndOrgInfoRespDtoRestResponse);
                bean.setMerchantName(OrgAndOrgInfoRespDto2.getOrganizationDto().getName());
            });
            List<String> businessNos = dtoList.stream().filter(bean -> StringUtils.isNotEmpty((CharSequence)bean.getType()) && (RebateTypeEnum.ORDER_REBATE.getType().toString().equals(bean.getType()) || RebateTypeEnum.MANUAL_REBATE.getType().toString().equals(bean.getType())) && StringUtils.isNotEmpty((CharSequence)bean.getBusinessNo())).map(RebateDetailRespDto::getBusinessNo).collect(Collectors.toList());
            Map<String, List<OrderEo>> orderEoMap = this.queryRebateOrderByNos(businessNos);
            dtoList.stream().forEach(bean -> {
                List orderEos;
                if (StringUtils.isNotEmpty((CharSequence)bean.getBusinessNo()) && null != orderEoMap && CollectionUtils.isNotEmpty((Collection)(orderEos = (List)orderEoMap.get(bean.getBusinessNo())))) {
                    bean.setRebateOrderId(((OrderEo)orderEos.get(0)).getId());
                }
            });
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private RebateDetailEo getRebateDetailEo(RebateDetailQueryReqDto reqDto) {
        RestResponse response;
        Long userOrganizationId;
        RestResponse companyResponse;
        CustomerRespDto customerRespDto;
        RebateDetailEo rebateDetailEo = new RebateDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rebateDetailEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (null != reqDto.getBeginTime()) {
            sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)reqDto.getBeginTime()));
        }
        if (null != reqDto.getEndTime()) {
            sqlFilters.add(SqlFilter.le((String)"create_time", (Object)reqDto.getEndTime()));
        }
        rebateDetailEo.setSqlFilters(sqlFilters);
        ArrayList sqlOrderByList = Lists.newArrayList();
        sqlOrderByList.add(new SqlOrderBy("create_time", SortOrder.DESC));
        sqlOrderByList.add(new SqlOrderBy("id", SortOrder.DESC));
        rebateDetailEo.setSqlOrderBys((List)sqlOrderByList);
        if (StringUtils.isNotBlank((CharSequence)reqDto.getMerchantIdList())) {
            StringBuilder userIdList = new StringBuilder();
            RestResponse response2 = this.customerExtQueryApi.queryCurrentUserOrgId();
            Long userOrganizationId2 = (Long)RestResponseHelper.extractData((RestResponse)response2);
            List customerList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdAndMerchantIds(Stream.of(reqDto.getMerchantIdList().split(",")).map(Long::parseLong).collect(Collectors.toList()), userOrganizationId2));
            logger.info("\u4ee3\u5ba2\u4e0b\u5355-\u5f52\u5c5e\uff1a{}", (Object)JSON.toJSONString((Object)customerList));
            if (CollectionUtils.isNotEmpty((Collection)customerList)) {
                for (CustomerRespDto customerRespDto2 : customerList) {
                    userIdList.append(customerRespDto2.getId());
                    userIdList.append(",");
                }
            }
            if (userIdList.length() > 0) {
                reqDto.setUserIdList(userIdList.substring(0, userIdList.length() - 1));
            }
        }
        if (reqDto.getMerchantId() != null && (customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)(companyResponse = this.customerExtQueryApi.queryCustomerByOrgAndMerch(userOrganizationId = (Long)RestResponseHelper.extractData((RestResponse)(response = this.customerExtQueryApi.queryCurrentUserOrgId())), Long.valueOf(reqDto.getMerchantId()))))) != null) {
            reqDto.setUserId(customerRespDto.getId());
        }
        if (reqDto.getUserId() != null && StringUtils.isBlank((CharSequence)reqDto.getUserIdList())) {
            sqlFilters.add(SqlFilter.eq((String)"user_id", (Object)reqDto.getUserId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUserIdList())) {
            sqlFilters.add(SqlFilter.in((String)"user_id", (Object)StringUtils.join((Object[])new String[]{reqDto.getUserIdList(), ","})));
        }
        if (reqDto.getType() != null && StringUtils.isBlank((CharSequence)reqDto.getTypeList())) {
            sqlFilters.add(SqlFilter.eq((String)"type", (Object)reqDto.getUserId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getTypeList())) {
            sqlFilters.add(SqlFilter.in((String)"type", (Object)StringUtils.join((Object[])new String[]{reqDto.getTypeList(), ","})));
        }
        return rebateDetailEo;
    }

    @Override
    public List<RebateDetailRespDto> queryWillExpireRebateDetail(RebateDetailQueryReqDto reqDto) {
        ArrayList<RebateDetailRespDto> rebateDetailRespDtos = new ArrayList<RebateDetailRespDto>();
        if (null == reqDto.getUserId()) {
            return rebateDetailRespDtos;
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        Calendar now = Calendar.getInstance();
        sqlFilters.add(SqlFilter.ge((String)"expired_time", (Object)now.getTime()));
        now.add(5, 30);
        sqlFilters.add(SqlFilter.le((String)"expired_time", (Object)now.getTime()));
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getTypeList())) {
            sqlFilters.add(SqlFilter.in((String)"type", (Object)StringUtils.join((Object[])new String[]{reqDto.getTypeList(), ","})));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getUserIdList())) {
            sqlFilters.add(SqlFilter.in((String)"user_id", (Object)StringUtils.join((Object[])new String[]{reqDto.getUserIdList(), ","})));
        }
        RebateDetailEo rebateDetailEo = new RebateDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rebateDetailEo);
        rebateDetailEo.setSqlFilters(sqlFilters);
        List select = this.rebateDetailDas.select((BaseEo)rebateDetailEo);
        DtoHelper.eoList2DtoList((Collection)select, rebateDetailRespDtos, RebateDetailRespDto.class);
        return rebateDetailRespDtos;
    }

    @Override
    public RebateDetailCountRespDto countRebateDetail(RebateDetailQueryReqDto reqDto) {
        RebateDetailCountRespDto rebateDetailCountRespDto = new RebateDetailCountRespDto();
        RebateDetailEo rebateDetailEo = new RebateDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rebateDetailEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)reqDto.getBeginTime()));
        sqlFilters.add(SqlFilter.le((String)"create_time", (Object)reqDto.getEndTime()));
        rebateDetailEo.setSqlFilters(sqlFilters);
        List rebateDetailEos = this.rebateDetailDas.select((BaseEo)rebateDetailEo);
        if (CollectionUtils.isNotEmpty((Collection)rebateDetailEos)) {
            BigDecimal income = rebateDetailEos.stream().filter(bean -> {
                if (null == bean.getChangeAmount()) {
                    return false;
                }
                return bean.getChangeAmount().compareTo(BigDecimal.ZERO) > 0;
            }).map(StdRebateDetailEo::getChangeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            rebateDetailCountRespDto.setIncome(income == null ? BigDecimal.ZERO : income);
            BigDecimal expend = rebateDetailEos.stream().filter(bean -> {
                if (null == bean.getChangeAmount()) {
                    return false;
                }
                return bean.getChangeAmount().compareTo(BigDecimal.ZERO) < 0;
            }).map(StdRebateDetailEo::getChangeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            rebateDetailCountRespDto.setExpend(expend == null ? BigDecimal.ZERO : expend);
        }
        return rebateDetailCountRespDto;
    }

    @Override
    public RebateDetailSumRespDto listSum(RebateDetailQueryReqDto reqDto) {
        this.getRebateDetailEo(reqDto);
        logger.info("\u8bf7\u6c42\u53c2\u6570\uff1areqDto= {}", JSONObject.toJSON((Object)reqDto));
        RebateDetailSumRespDto respDto = new RebateDetailSumRespDto();
        List list = this.rebateDetailDas.listSum(reqDto);
        for (Map map : list) {
            String incomeExpenditure = String.valueOf(map.get("type"));
            BigDecimal totalAmount = new BigDecimal(String.valueOf(map.get("changeAmount")));
            if (incomeExpenditure != null && ObjectUtil.equal((Object)incomeExpenditure, (Object)"1")) {
                respDto.setPayAmountTotal(totalAmount);
            }
            if (incomeExpenditure == null || !ObjectUtil.equal((Object)incomeExpenditure, (Object)"2")) continue;
            respDto.setIncomeAmountTotal(totalAmount);
        }
        return respDto;
    }

    private Map<String, List<OrderEo>> queryRebateOrderByNos(List<String> businessNos) {
        if (CollectionUtils.isNotEmpty(businessNos)) {
            OrderEo orderEo = new OrderEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"rebate_no", businessNos));
            orderEo.setSqlFilters(sqlFilters);
            List orderEos = this.orderDas.select((BaseEo)orderEo);
            if (CollectionUtils.isNotEmpty((Collection)orderEos)) {
                return orderEos.stream().collect(Collectors.groupingBy(StdOrderEo::getRebateNo));
            }
        }
        return null;
    }
}

