/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RefundItemReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RefundItemRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IRefundItemService;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RefundItemDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RefundItemEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.vo.RefundItemStatisticVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RefundItemServiceImpl
implements IRefundItemService {
    @Resource
    private RefundItemDas refundItemDas;

    @Override
    public Long addRefundItem(RefundItemReqDto addReqDto) {
        RefundItemEo refundItemEo = new RefundItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)refundItemEo);
        this.refundItemDas.insert((BaseEo)refundItemEo);
        return refundItemEo.getId();
    }

    @Override
    public void modifyRefundItem(RefundItemReqDto modifyReqDto) {
        RefundItemEo refundItemEo = new RefundItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)refundItemEo);
        this.refundItemDas.updateSelective((BaseEo)refundItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRefundItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.refundItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public RefundItemRespDto queryById(Long id) {
        RefundItemEo refundItemEo = (RefundItemEo)this.refundItemDas.selectByPrimaryKey(id);
        RefundItemRespDto refundItemRespDto = new RefundItemRespDto();
        DtoHelper.eo2Dto((BaseEo)refundItemEo, (BaseVo)refundItemRespDto);
        return refundItemRespDto;
    }

    @Override
    public PageInfo<RefundItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        RefundItemReqDto refundItemReqDto = (RefundItemReqDto)JSON.parseObject((String)filter, RefundItemReqDto.class);
        RefundItemEo refundItemEo = new RefundItemEo();
        DtoHelper.dto2Eo((BaseVo)refundItemReqDto, (BaseEo)refundItemEo);
        PageInfo eoPageInfo = this.refundItemDas.selectPage((BaseEo)refundItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, RefundItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public RefundItemStatisticVo statisticByPreSettleId(Long preSettlementId) {
        return this.refundItemDas.statisticByPreSettleId(preSettlementId);
    }

    @Override
    public boolean checkRefundOrderExists(String refundNo) {
        RefundItemEo refundItemEo = new RefundItemEo();
        refundItemEo.setRefundNo(refundNo);
        List refundItemEoList = this.refundItemDas.select((BaseEo)refundItemEo);
        boolean exists = !CollectionUtils.isEmpty((Collection)refundItemEoList);
        return exists;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchSave(List<RefundItemEo> refundItemEoList) {
        return this.refundItemDas.insertBatch(refundItemEoList);
    }
}

