/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchConditionVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ParentAreCodeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerGroupQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateUseStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RuleUseObjectTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.CustomerDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderRebateAmountQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateUseRuleSearchDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateUseRuleSearchItemDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RuleAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RuleModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RuleReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RuleRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.condition.ConditionTemplate;
import com.dtyunxi.yundt.cube.center.rebate.biz.condition.RuleFactory;
import com.dtyunxi.yundt.cube.center.rebate.biz.constant.ConditionBusinessType;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IRuleService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.gateway.OrganizationGateway;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.ConvertUtil;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.ConditionDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RuleDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.ConditionEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RuleEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RuleServiceImpl
implements IRuleService {
    private Logger logger = LoggerFactory.getLogger(RuleServiceImpl.class);
    @Resource
    private RuleDas ruleDas;
    @Resource
    private ConditionDas conditionDas;
    @Resource
    private IContext iContext;
    @Resource
    private ISearchIndexService searchIndexService;
    @Resource
    private IOpenSearchService openSearchService;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICustomerGroupQueryApi customerGroupQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private OrganizationGateway organizationGateway;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addRule(RuleAddReqDto addDto) {
        addDto.setOrganizationId(this.organizationGateway.getOrganizationId());
        RestResponse orgAndOrgInfoRespDtoRestResponse = this.organizationQueryApi.queryOrgAndOrgInfo(addDto.getOrganizationId());
        OrgAndOrgInfoRespDto orgAndOrgInfoRespData = (OrgAndOrgInfoRespDto)orgAndOrgInfoRespDtoRestResponse.getData();
        if (null != orgAndOrgInfoRespData && null != orgAndOrgInfoRespData.getOrganizationDto()) {
            addDto.setOrganizationName(orgAndOrgInfoRespData.getOrganizationDto().getName());
        }
        this.validateRule((RuleReqDto)addDto, null);
        this.initCustomerDimensionData((RuleReqDto)addDto);
        RuleEo ruleEo = new RuleEo();
        DtoHelper.dto2Eo((BaseVo)addDto, (BaseEo)ruleEo);
        this.ruleDas.insert((BaseEo)ruleEo);
        List<ConditionEo> conditions = this.dto2Condition(addDto);
        conditions.forEach(conditionEo -> conditionEo.setBusinessId(ruleEo.getId()));
        this.conditionDas.insertBatch(conditions);
        RebateUseRuleSearchDto searchDto = this.buildSearchBean((RuleReqDto)addDto, ruleEo.getId(), addDto.getStatus());
        this.createSearchData(searchDto);
        return ruleEo.getId();
    }

    private void initCustomerDimensionData(RuleReqDto addDto) {
        switch (addDto.getCustomerDimension()) {
            case 0: {
                addDto.setCustomerTypeIds(new ArrayList());
                addDto.setCustomerAreaCodes(new ArrayList());
                addDto.setCustomerGroupIds(new ArrayList());
                addDto.setCustomerClassIds(new ArrayList());
                break;
            }
            case 1: {
                addDto.setCustomers(new ArrayList());
                addDto.setCustomerAreaCodes(new ArrayList());
                addDto.setCustomerGroupIds(new ArrayList());
                addDto.setCustomerClassIds(new ArrayList());
                break;
            }
            case 2: {
                addDto.setCustomers(new ArrayList());
                addDto.setCustomerTypeIds(new ArrayList());
                addDto.setCustomerGroupIds(new ArrayList());
                addDto.setCustomerClassIds(new ArrayList());
                break;
            }
            case 3: {
                addDto.setCustomers(new ArrayList());
                addDto.setCustomerTypeIds(new ArrayList());
                addDto.setCustomerAreaCodes(new ArrayList());
                addDto.setCustomerClassIds(new ArrayList());
                break;
            }
            case 4: {
                addDto.setCustomers(new ArrayList());
                addDto.setCustomerTypeIds(new ArrayList());
                addDto.setCustomerAreaCodes(new ArrayList());
                addDto.setCustomerGroupIds(new ArrayList());
                addDto.setCustomerClassIds(new ArrayList());
                break;
            }
            case 5: {
                addDto.setCustomers(new ArrayList());
                addDto.setCustomerTypeIds(new ArrayList());
                addDto.setCustomerAreaCodes(new ArrayList());
                addDto.setCustomerGroupIds(new ArrayList());
                break;
            }
        }
    }

    private void validateCustomerDimension(RuleReqDto addDto) {
        Integer customerDimension = addDto.getCustomerDimension();
        Assert.notNull(customerDimension, ExceptionCode.INVALID_PARAM.getCode(), "\u5ba2\u6237\u7ef4\u5ea6\u503c\u9519\u8bef");
        CustomerDimensionEnum code = CustomerDimensionEnum.getByCode((Integer)customerDimension);
        Assert.notNull(code, ExceptionCode.INVALID_PARAM.getCode(), "\u5ba2\u6237\u7ef4\u5ea6\u503c\u8303\u56f4\u9519\u8bef");
        switch (code) {
            case SPECIFIED: {
                Assert.isTrue(CollUtil.isNotEmpty((Collection)addDto.getCustomers()), ExceptionCode.INVALID_PARAM.getCode(), "\u6307\u5b9a\u5ba2\u6237\u8303\u56f4\u9519\u8bef");
                break;
            }
            case TYPE: {
                Assert.isTrue(CollUtil.isNotEmpty((Collection)addDto.getCustomerTypeIds()), ExceptionCode.INVALID_PARAM.getCode(), "\u6307\u5b9a\u5ba2\u6237\u7c7b\u578b\u8303\u56f4\u9519\u8bef");
                break;
            }
            case REGION: {
                Assert.isTrue(CollUtil.isNotEmpty((Collection)addDto.getCustomerAreaCodes()), ExceptionCode.INVALID_PARAM.getCode(), "\u6307\u5b9a\u5ba2\u6237\u533a\u57df\u9519\u8bef");
                break;
            }
            case GROUP: {
                Assert.isTrue(CollUtil.isNotEmpty((Collection)addDto.getCustomerGroupIds()), ExceptionCode.INVALID_PARAM.getCode(), "\u6307\u5b9a\u5ba2\u6237\u5206\u7ec4\u9519\u8bef");
                break;
            }
            case CLASS: {
                Assert.isTrue(CollUtil.isNotEmpty((Collection)addDto.getCustomerClassIds()), ExceptionCode.INVALID_PARAM.getCode(), "\u6307\u5b9a\u5ba2\u6237\u7ea7\u522b\u9519\u8bef");
                break;
            }
        }
    }

    private void validateRule(RuleReqDto addDto, Long id) {
        this.validateName(addDto, id);
        List<Object> rebateUseRuleSearchDtos = this.searchRebateUseRule(addDto);
        if (CollectionUtils.isNotEmpty(rebateUseRuleSearchDtos)) {
            boolean enable;
            List enableList = (rebateUseRuleSearchDtos = rebateUseRuleSearchDtos.stream().filter(bean -> addDto.getOrganizationId().equals(bean.getOrganizationId())).collect(Collectors.toList())).stream().filter(bean -> bean.getStatus() == 1L).collect(Collectors.toList());
            boolean bl = enable = CollectionUtils.isNotEmpty(enableList) && enableList.size() > 0;
            if (null == id && enable) {
                throw new BizException("\u5173\u8054\u5ba2\u6237\u5df2\u5b58\u5728\u3002\u89c4\u5219\u540d\u79f0:" + enableList.stream().map(RebateUseRuleSearchDto::getName).collect(Collectors.joining(",")));
            }
            List collect = rebateUseRuleSearchDtos.stream().filter(bean -> !bean.getRuleId().equals(id) && bean.getStatus() == 1L).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                throw new BizException("\u5173\u8054\u5ba2\u6237\u5df2\u5b58\u5728\u3002\u89c4\u5219\u540d\u79f0:" + enableList.stream().map(RebateUseRuleSearchDto::getName).collect(Collectors.joining(",")));
            }
        }
    }

    private List<RebateUseRuleSearchDto> searchRebateUseRule(RuleReqDto ruleReqDto) {
        SearchResultVo searchResultVo;
        this.validateCustomerDimension(ruleReqDto);
        List<Object> result = new ArrayList<RebateUseRuleSearchDto>();
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setIndexName("rebate_use_rule_" + this.globalProfile);
        osSearchVo.setTypeName("rebate_use_rule");
        if (null != ruleReqDto.getCustomerDimension()) {
            osSearchVo.addEqualFilter("customerDimension", String.valueOf(ruleReqDto.getCustomerDimension()));
        }
        if (CustomerDimensionEnum.SPECIFIED.getType().equals(ruleReqDto.getCustomerDimension()) && CollectionUtils.isNotEmpty((Collection)ruleReqDto.getCustomers())) {
            List customerIds = ruleReqDto.getCustomers().stream().map(CustomerDto::getCustomerId).collect(Collectors.toList());
            osSearchVo.addInFilter("customerIds.customerId", ConvertUtil.convert2Array(customerIds));
        }
        if (CustomerDimensionEnum.TYPE.getType().equals(ruleReqDto.getCustomerDimension()) && CollectionUtils.isNotEmpty((Collection)ruleReqDto.getCustomerTypeIds())) {
            osSearchVo.addInFilter("customerTypeIds.customerTypeId", ConvertUtil.convert2Array(ruleReqDto.getCustomerTypeIds()));
        }
        if (CustomerDimensionEnum.GROUP.getType().equals(ruleReqDto.getCustomerDimension()) && CollectionUtils.isNotEmpty((Collection)ruleReqDto.getCustomerGroupIds())) {
            osSearchVo.addInFilter("customerGroupIds.customerGroupId", ConvertUtil.convert2Array(ruleReqDto.getCustomerGroupIds()));
        }
        if (CustomerDimensionEnum.REGION.getType().equals(ruleReqDto.getCustomerDimension()) && CollectionUtils.isNotEmpty((Collection)ruleReqDto.getCustomerAreaCodes())) {
            osSearchVo.addInFilter("customerAreaCodes.customerAreaCode", ConvertUtil.convert2Array(ruleReqDto.getCustomerAreaCodes()));
        }
        if (CustomerDimensionEnum.CLASS.getType().equals(ruleReqDto.getCustomerDimension()) && CollectionUtils.isNotEmpty((Collection)ruleReqDto.getCustomerAreaCodes())) {
            osSearchVo.addInFilter("customerClasses.customerClassId", ConvertUtil.convert2Array(ruleReqDto.getCustomerClassIds()));
        }
        if (CustomerDimensionEnum.ALL.getType().equals(ruleReqDto.getCustomerDimension()) && CollectionUtils.isNotEmpty((Collection)ruleReqDto.getRuleContent())) {
            ArrayList<String> targetObjectType = new ArrayList<String>();
            ruleReqDto.getRuleContent().forEach(ruleUseRuleContentReqDto -> targetObjectType.add(ruleUseRuleContentReqDto.getType().toCode()));
            if (!targetObjectType.contains(RuleUseObjectTypeEnum.ALL.toCode())) {
                targetObjectType.add("ALL");
                osSearchVo.addInFilter("ruleObjectType", ConvertUtil.convert2Array(targetObjectType));
            } else {
                ArrayList<String> allObjectType = new ArrayList<String>();
                for (RuleUseObjectTypeEnum typeEnum : RuleUseObjectTypeEnum.values()) {
                    allObjectType.add(typeEnum.toCode());
                }
                osSearchVo.addInFilter("ruleObjectType", ConvertUtil.convert2Array(allObjectType));
            }
        }
        if (null != (searchResultVo = this.openSearchService.search(osSearchVo))) {
            result = searchResultVo.getDocValues(docValue -> (RebateUseRuleSearchDto)BeanUtil.mapToBean((Map)docValue, RebateUseRuleSearchDto.class, (boolean)true));
        }
        return result;
    }

    private void validateName(RuleReqDto addDto, Long id) {
        int count;
        RuleEo ruleEo = new RuleEo();
        ruleEo.setName(addDto.getName());
        ruleEo.setTenantId(this.context.tenantId());
        ruleEo.setInstanceId(this.context.instanceId());
        ruleEo.setDr(0);
        ruleEo.setOrganizationId(this.organizationGateway.getOrganizationId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.setEntity((Object)ruleEo);
        if (Objects.nonNull(id)) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        Assert.isTrue((count = this.ruleDas.count((Wrapper)queryWrapper)) == 0, ExceptionCode.FAIL.getCode(), "\u5df2\u5b58\u5728\u76f8\u540c\u4f7f\u7528\u89c4\u5219\u540d\u79f0: " + addDto.getName());
    }

    private <T extends RuleReqDto> List<ConditionEo> dto2Condition(T t) {
        List<ConditionTemplate> conditionTemplates = RuleFactory.getTemplate(ConditionBusinessType.REBATE_RULE);
        ArrayList<ConditionEo> result = new ArrayList<ConditionEo>();
        for (ConditionTemplate conditionTemplate : conditionTemplates) {
            ConditionReqDto conditionReqDto = conditionTemplate.convertToCondition(t);
            ConditionEo conditionEo = new ConditionEo();
            DtoHelper.dto2Eo((BaseVo)conditionReqDto, (BaseEo)conditionEo);
            result.add(conditionEo);
        }
        return result;
    }

    private RuleReqDto conditionEo2RuleReqDto(List<ConditionEo> conditionEoList) {
        List<ConditionTemplate> conditionTemplates = RuleFactory.getTemplate(ConditionBusinessType.REBATE_RULE);
        RuleReqDto reqDto = new RuleReqDto();
        ArrayList<ConditionRespDto> conditionRespDtoList = new ArrayList<ConditionRespDto>();
        CubeBeanUtils.copyCollection(conditionRespDtoList, conditionEoList, ConditionRespDto.class);
        for (ConditionTemplate conditionTemplate : conditionTemplates) {
            conditionTemplate.parseCondition(conditionRespDtoList, reqDto);
        }
        return reqDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyRule(RuleModifyReqDto reqDto) {
        if (CollectionUtils.isEmpty((Collection)reqDto.getRuleContent())) {
            throw new BizException("\u8bf7\u8bbe\u7f6e\u4f7f\u7528\u6761\u4ef6\u3002");
        }
        reqDto.setOrganizationId(this.organizationGateway.getOrganizationId());
        this.validateRule((RuleReqDto)reqDto, reqDto.getId());
        this.initCustomerDimensionData((RuleReqDto)reqDto);
        RuleEo ruleEo = new RuleEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)ruleEo);
        this.ruleDas.updateSelective((BaseEo)ruleEo);
        List<ConditionEo> conditions = this.dto2Condition(reqDto);
        ConditionEo deleteEo = new ConditionEo();
        deleteEo.setBusinessId(ruleEo.getId());
        deleteEo.setBusinessType(ConditionBusinessType.REBATE_RULE.getType());
        this.conditionDas.deleteByExample((BaseEo)deleteEo);
        conditions.forEach(conditionEo -> {
            conditionEo.setBusinessId(ruleEo.getId());
            conditionEo.setBusinessType(ConditionBusinessType.REBATE_RULE.getType());
        });
        this.conditionDas.insertBatch(conditions);
        RebateUseRuleSearchDto searchDto = this.buildSearchBean((RuleReqDto)reqDto, reqDto.getId(), reqDto.getStatus());
        this.updateSearchData(searchDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRule(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.ruleDas.logicDeleteById(Long.valueOf(id.trim()));
            this.deleteSearchByIndexId(id);
        }
    }

    @Override
    public RuleRespDto queryRuleById(Long id) {
        RuleRespDto ruleRespDto = new RuleRespDto();
        ruleRespDto.setRuleContent(new ArrayList());
        RuleEo ruleEo = (RuleEo)this.ruleDas.selectByPrimaryKey(id);
        if (ruleEo == null) {
            return null;
        }
        ConditionEo condition = new ConditionEo();
        condition.setBusinessId(id);
        condition.setBusinessType(ConditionBusinessType.REBATE_RULE.getType());
        List conditionEos = this.conditionDas.select((BaseEo)condition);
        RuleReqDto ruleReqDto = this.conditionEo2RuleReqDto(conditionEos);
        BeanUtils.copyProperties((Object)ruleReqDto, (Object)ruleRespDto);
        DtoHelper.eo2Dto((BaseEo)ruleEo, (BaseVo)ruleRespDto);
        return ruleRespDto;
    }

    @Override
    public PageInfo<RuleRespDto> queryRuleByPage(RuleQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        if (this.organizationGateway.getOrganizationId() != null) {
            reqDto.setOrganizationId(this.organizationGateway.getOrganizationId());
        }
        RuleEo ruleEo = new RuleEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)ruleEo);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        reqDto.setTenantId(this.iContext.tenantId());
        reqDto.setInstanceId(this.iContext.instanceId());
        List ruleEoList = this.ruleDas.selectPageList(reqDto);
        return new PageInfo(ruleEoList);
    }

    @Override
    public void stopRule(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            RuleEo ruleEo = new RuleEo();
            ruleEo.setId(Long.valueOf(id.trim()));
            ruleEo.setStatus(RebateUseStatusEnum.DISABLE.getType());
            this.ruleDas.updateSelective((BaseEo)ruleEo);
            this.updateESRuleStatus(id, RebateUseStatusEnum.DISABLE.getType());
        }
    }

    @Override
    public RebateUseRuleSearchDto rebateUseRuleEngine(OrderRebateAmountQueryReqDto queryReqDto) {
        List result;
        List regionCodeList;
        List result2;
        List result3;
        CustomerRespDto customerRespDto = (CustomerRespDto)this.customerQueryApi.queryById(queryReqDto.getCustomerId()).getData();
        this.logger.info("\u5ba2\u6237\u4fe1\u606f[{}]", (Object)JSON.toJSONString((Object)customerRespDto));
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setIndexName("rebate_use_rule_" + this.globalProfile);
        osSearchVo.setTypeName("rebate_use_rule");
        osSearchVo.setPageSize(2000);
        osSearchVo.addEqualFilter("status", "1");
        String[] customerIdArray = new String[]{queryReqDto.getCustomerId().toString()};
        osSearchVo.addInFilter("customerIds.customerId", customerIdArray);
        this.logger.info("\u6307\u5b9a\u5ba2\u6237es\u67e5\u8be2\u6761\u4ef6={}", JSON.toJSON((Object)osSearchVo));
        SearchResultVo searchCustomerIdResultVo = this.openSearchService.search(osSearchVo);
        this.logger.info("\u6307\u5b9a\u5ba2\u6237es\u8fd4\u56de\u7ed3\u679c={}", JSON.toJSON((Object)searchCustomerIdResultVo));
        if (null != searchCustomerIdResultVo && !(result3 = searchCustomerIdResultVo.getDocValues(docValue -> (RebateUseRuleSearchDto)BeanUtil.mapToBean((Map)docValue, RebateUseRuleSearchDto.class, (boolean)true))).isEmpty()) {
            for (RebateUseRuleSearchDto useRuleSearchDto : result3) {
                if (useRuleSearchDto.getOrganizationId() == null || !useRuleSearchDto.getOrganizationId().equals(queryReqDto.getSellerOrgId())) continue;
                return useRuleSearchDto;
            }
        }
        osSearchVo.setFilterFields(null);
        osSearchVo.addEqualFilter("status", "1");
        CustomerTypeRespDto customerTypeRespDto = (CustomerTypeRespDto)this.customerTypeQueryApi.queryByCustomerId(queryReqDto.getCustomerId()).getData();
        String[] customerTypeIdArray = new String[]{customerTypeRespDto.getId().toString()};
        osSearchVo.addInFilter("customerTypeIds.customerTypeId", customerTypeIdArray);
        this.logger.info("\u5ba2\u6237\u5206\u7c7bes\u67e5\u8be2\u6761\u4ef6={}", JSON.toJSON((Object)osSearchVo));
        SearchResultVo searchCustomerTypeResultVo = this.openSearchService.search(osSearchVo);
        this.logger.info("\u5ba2\u6237\u5206\u7c7bes\u8fd4\u56de\u7ed3\u679c={}", JSON.toJSON((Object)searchCustomerTypeResultVo));
        if (null != searchCustomerTypeResultVo && !(result2 = searchCustomerTypeResultVo.getDocValues(docValue -> (RebateUseRuleSearchDto)BeanUtil.mapToBean((Map)docValue, RebateUseRuleSearchDto.class, (boolean)true))).isEmpty()) {
            for (RebateUseRuleSearchDto useRuleSearchDto : result2) {
                if (useRuleSearchDto.getOrganizationId() == null || !useRuleSearchDto.getOrganizationId().equals(queryReqDto.getSellerOrgId())) continue;
                return useRuleSearchDto;
            }
        }
        osSearchVo.setFilterFields(null);
        osSearchVo.addEqualFilter("status", "1");
        List<Long> groupIds = this.getParentGCustomerGroupIds(customerRespDto.getCustomerGroupId());
        if (!CollectionUtils.isEmpty(groupIds)) {
            List result4;
            osSearchVo.addInFilter("customerGroupIds.customerGroupId", ConvertUtil.convert2Array(groupIds));
            this.logger.info("\u5ba2\u6237\u5206\u7ec4es\u67e5\u8be2\u6761\u4ef6={}", JSON.toJSON((Object)osSearchVo));
            SearchResultVo searchCustomerGroupResultVo = this.openSearchService.search(osSearchVo);
            this.logger.info("\u5ba2\u6237\u5206\u7ec4es\u8fd4\u56de\u7ed3\u679c={}", JSON.toJSON((Object)searchCustomerGroupResultVo));
            if (null != searchCustomerGroupResultVo && !(result4 = searchCustomerGroupResultVo.getDocValues(docValue -> (RebateUseRuleSearchDto)BeanUtil.mapToBean((Map)docValue, RebateUseRuleSearchDto.class, (boolean)true))).isEmpty()) {
                for (RebateUseRuleSearchDto useRuleSearchDto : result4) {
                    if (useRuleSearchDto.getOrganizationId() == null || !useRuleSearchDto.getOrganizationId().equals(queryReqDto.getSellerOrgId())) continue;
                    return useRuleSearchDto;
                }
            }
        }
        osSearchVo.setFilterFields(null);
        osSearchVo.addEqualFilter("status", "1");
        List areaCodes = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)customerRespDto.getRegionCodeList()) && CollectionUtils.isNotEmpty(regionCodeList = customerRespDto.getRegionCodeList().stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList()))) {
            ParentAreCodeReqDto parentAreCodeReqDto = new ParentAreCodeReqDto();
            parentAreCodeReqDto.setCodes(regionCodeList);
            this.logger.info("\u5ba2\u6237\u533a\u57df\u7f16\u7801: {}", (Object)JSON.toJSONString((Object)customerRespDto.getRegionCodeList()));
            RestResponse customerAreaResponse = this.customerAreaQueryApi.queryAllParentCode(parentAreCodeReqDto);
            areaCodes = (List)RestResponseHelper.extractData((RestResponse)customerAreaResponse);
            this.logger.info("\u5ba2\u6237\u533a\u57df: {}", (Object)JSON.toJSONString(areaCodes));
        }
        if (CollectionUtils.isNotEmpty(areaCodes)) {
            osSearchVo.addInFilter("customerAreaCodes.customerAreaCode", ConvertUtil.convert2Array(areaCodes));
            this.logger.info("\u5ba2\u6237\u533a\u57dfes\u67e5\u8be2\u6761\u4ef6={}", JSON.toJSON((Object)osSearchVo));
            SearchResultVo AreaCodeResultVo = this.openSearchService.search(osSearchVo);
            if (null != AreaCodeResultVo) {
                result = AreaCodeResultVo.getDocValues(docValue -> (RebateUseRuleSearchDto)BeanUtil.mapToBean((Map)docValue, RebateUseRuleSearchDto.class, (boolean)true));
                this.logger.info("\u5ba2\u6237\u533a\u57dfresult: {}", (Object)JSON.toJSONString((Object)result));
                if (!result.isEmpty()) {
                    for (Object useRuleSearchDto : result) {
                        if (useRuleSearchDto.getOrganizationId() == null || !useRuleSearchDto.getOrganizationId().equals(queryReqDto.getSellerOrgId())) continue;
                        return useRuleSearchDto;
                    }
                    this.logger.info("\u5ba2\u6237\u533a\u57df_\u65e0\u6cd5\u5339\u914d");
                }
            }
        }
        osSearchVo.setFilterFields(null);
        osSearchVo.addEqualFilter("status", "1");
        if (customerRespDto.getLevelId() != null) {
            List result5;
            String[] customerClassIdArray = new String[]{customerRespDto.getLevelId().toString()};
            osSearchVo.addInFilter("customerClasses.customerClassId", customerClassIdArray);
            this.logger.info("\u5ba2\u6237\u7ea7\u522bes\u67e5\u8be2\u6761\u4ef6={}", JSON.toJSON((Object)osSearchVo));
            SearchResultVo searchCustomerClassResultVo = this.openSearchService.search(osSearchVo);
            this.logger.info("\u5ba2\u6237\u7ea7\u522bes\u8fd4\u56de\u7ed3\u679c={}", JSON.toJSON((Object)searchCustomerClassResultVo));
            if (null != searchCustomerClassResultVo && !(result5 = searchCustomerClassResultVo.getDocValues(docValue -> (RebateUseRuleSearchDto)BeanUtil.mapToBean((Map)docValue, RebateUseRuleSearchDto.class, (boolean)true))).isEmpty()) {
                for (RebateUseRuleSearchDto useRuleSearchDto : result5) {
                    if (useRuleSearchDto.getOrganizationId() == null || !useRuleSearchDto.getOrganizationId().equals(queryReqDto.getSellerOrgId())) continue;
                    return useRuleSearchDto;
                }
            }
        }
        osSearchVo.setFilterFields(null);
        osSearchVo.addEqualFilter("status", "1");
        osSearchVo.addEqualFilter("customerDimension", String.valueOf(CustomerDimensionEnum.ALL.getType()));
        this.logger.info("\u5168\u90e8\u5ba2\u6237es\u67e5\u8be2\u6761\u4ef6={}", JSON.toJSON((Object)osSearchVo));
        SearchResultVo searchAllCustomerResultVo = this.openSearchService.search(osSearchVo);
        this.logger.info("\u5168\u90e8\u5ba2\u6237es\u8fd4\u56de\u7ed3\u679c={}", JSON.toJSON((Object)searchAllCustomerResultVo));
        if (null != searchAllCustomerResultVo && !(result = searchAllCustomerResultVo.getDocValues(docValue -> (RebateUseRuleSearchDto)BeanUtil.mapToBean((Map)docValue, RebateUseRuleSearchDto.class, (boolean)true))).isEmpty()) {
            for (Object useRuleSearchDto : result) {
                if (useRuleSearchDto.getOrganizationId() == null || !useRuleSearchDto.getOrganizationId().equals(queryReqDto.getSellerOrgId())) continue;
                return useRuleSearchDto;
            }
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={BizException.class})
    public void modifyRuleStatus(Long id, Integer status) {
        if (RebateUseStatusEnum.ENABLE.getType().equals(status)) {
            ConditionEo condition = new ConditionEo();
            condition.setBusinessId(id);
            condition.setBusinessType(ConditionBusinessType.REBATE_RULE.getType());
            List conditionEos = this.conditionDas.select((BaseEo)condition);
            RuleReqDto ruleReqDto = this.conditionEo2RuleReqDto(conditionEos);
            ruleReqDto.setOrganizationId(this.organizationGateway.getOrganizationId());
            RuleEo temp = (RuleEo)this.ruleDas.selectByPrimaryKey(id);
            if (temp != null) {
                ruleReqDto.setName(temp.getName());
            }
            this.validateRule(ruleReqDto, id);
        }
        RuleEo ruleEo = new RuleEo();
        ruleEo.setId(id);
        ruleEo.setStatus(status);
        this.ruleDas.updateSelective((BaseEo)ruleEo);
        this.updateESRuleStatus(id.toString(), status);
    }

    private void updateESRuleStatus(String id, Integer status) {
        SearchConditionVo conditionVo = new SearchConditionVo("rebate_use_rule_" + this.globalProfile, "rebate_use_rule");
        conditionVo.setIds(new String[]{id});
        HashMap<String, Integer> docMap = new HashMap<String, Integer>();
        docMap.put("status", status);
        this.searchIndexService.updateDataByCondition(conditionVo, docMap);
    }

    private void createSearchData(RebateUseRuleSearchDto searchDto) {
        IndexDocumentVo doc = this.newInstance();
        List<IndexDocContentVo> indexDocContents = this.getIndexDocContents(searchDto);
        doc.setContents(indexDocContents);
        this.logger.info("\u65b0\u589e\u89c4\u5219\u7d22\u5f15\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)doc));
        this.searchIndexService.addData(doc);
    }

    private List<IndexDocContentVo> getIndexDocContents(RebateUseRuleSearchDto searchDto) {
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo contentVo = new IndexDocContentVo();
        Map docValueMap = CustomBeanUtils.describe((Object)searchDto);
        contentVo.setDocValueMap(docValueMap);
        contentVo.setIndexId(String.valueOf(searchDto.getRuleId()));
        contents.add(contentVo);
        return contents;
    }

    private RebateUseRuleSearchDto buildSearchBean(RuleReqDto addDto, Long ruleId, Integer status) {
        List customerIds;
        RebateUseRuleSearchDto searchDto = new RebateUseRuleSearchDto();
        searchDto.setRuleId(ruleId);
        searchDto.setName(addDto.getName());
        searchDto.setTenantId(this.context.tenantId());
        searchDto.setInstanceId(this.context.instanceId());
        searchDto.setOrganizationId(addDto.getOrganizationId());
        if (null != status) {
            searchDto.setStatus(Long.valueOf(status.intValue()));
        }
        if (CollectionUtils.isNotEmpty((Collection)addDto.getRuleContent())) {
            ArrayList rules = new ArrayList();
            ArrayList ruleObjectType = new ArrayList();
            addDto.getRuleContent().forEach(ruleUseRuleContentReqDto -> {
                RebateUseRuleSearchItemDto itemDto = new RebateUseRuleSearchItemDto();
                itemDto.setType(ruleUseRuleContentReqDto.getType().toCode());
                if (Objects.nonNull(ruleUseRuleContentReqDto.getReachAnAmountOption()) && ruleUseRuleContentReqDto.getReachAnAmountOption().booleanValue()) {
                    itemDto.setThresholdAmount(ruleUseRuleContentReqDto.getReachAnAmount());
                } else {
                    itemDto.setThresholdAmount(null);
                }
                if (Objects.nonNull(ruleUseRuleContentReqDto.getNoMoreThanOption()) && ruleUseRuleContentReqDto.getNoMoreThanOption().booleanValue()) {
                    itemDto.setUseRadio(ruleUseRuleContentReqDto.getNoMoreThan());
                } else {
                    itemDto.setUseRadio(null);
                }
                rules.add(itemDto);
                ruleObjectType.add(ruleUseRuleContentReqDto.getType().toCode());
            });
            searchDto.setRules(rules);
            searchDto.setRuleObjectType(ruleObjectType);
        }
        if (null != addDto.getCustomerDimension()) {
            searchDto.setCustomerDimension(Long.valueOf(addDto.getCustomerDimension().intValue()));
        }
        if (CollectionUtils.isNotEmpty((Collection)addDto.getCustomers()) && CollectionUtils.isNotEmpty(customerIds = addDto.getCustomers().stream().map(CustomerDto::getCustomerId).collect(Collectors.toList()))) {
            searchDto.setCustomerIds(customerIds.stream().map(bean -> {
                RebateUseRuleSearchDto.RuleCustomer ruleCustomer = new RebateUseRuleSearchDto.RuleCustomer();
                ruleCustomer.setCustomerId(bean);
                return ruleCustomer;
            }).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty((Collection)addDto.getCustomerTypeIds())) {
            ArrayList customerTypes = new ArrayList();
            addDto.getCustomerTypeIds().forEach(bean -> {
                RebateUseRuleSearchDto.CustomerType customerType = new RebateUseRuleSearchDto.CustomerType();
                customerType.setCustomerTypeId(bean);
                customerTypes.add(customerType);
            });
            searchDto.setCustomerTypeIds(customerTypes);
        }
        if (CollectionUtils.isNotEmpty((Collection)addDto.getCustomerAreaCodes())) {
            ArrayList customerAreaCodes = new ArrayList();
            addDto.getCustomerAreaCodes().forEach(bean -> {
                RebateUseRuleSearchDto.CustomerAreaCode customerAreaCode = new RebateUseRuleSearchDto.CustomerAreaCode();
                customerAreaCode.setCustomerAreaCode(bean);
                List<String> childrenAreaCodes = this.getChildrenAreaCodes((String)bean);
                if (CollectionUtils.isNotEmpty(childrenAreaCodes)) {
                    customerAreaCode.setChildrenCustomerAreaCodes(childrenAreaCodes.stream().map(child -> {
                        RebateUseRuleSearchDto.ChildrenCustomerAreaCode childrenCustomerAreaCode = new RebateUseRuleSearchDto.ChildrenCustomerAreaCode();
                        childrenCustomerAreaCode.setChildrenCustomerAreaCode(child);
                        return childrenCustomerAreaCode;
                    }).collect(Collectors.toList()));
                }
                customerAreaCodes.add(customerAreaCode);
            });
            searchDto.setCustomerAreaCodes(customerAreaCodes);
        }
        if (CollectionUtils.isNotEmpty((Collection)addDto.getCustomerGroupIds())) {
            ArrayList customerGroups = new ArrayList();
            addDto.getCustomerGroupIds().forEach(bean -> {
                RebateUseRuleSearchDto.CustomerGroup customerGroup = new RebateUseRuleSearchDto.CustomerGroup();
                customerGroup.setCustomerGroupId(bean);
                List<Long> childrenCustomerGroupIds = this.getChildrenCustomerGroupIds((Long)bean);
                if (CollectionUtils.isNotEmpty(childrenCustomerGroupIds)) {
                    customerGroup.setChildrenCustomerGroupIds(childrenCustomerGroupIds.stream().map(child -> {
                        RebateUseRuleSearchDto.ChildrenCustomerGroup childrenCustomerGroup = new RebateUseRuleSearchDto.ChildrenCustomerGroup();
                        childrenCustomerGroup.setChildrenCustomerGroupId(child);
                        return childrenCustomerGroup;
                    }).collect(Collectors.toList()));
                }
                customerGroups.add(customerGroup);
            });
            searchDto.setCustomerGroupIds(customerGroups);
        }
        if (CollectionUtils.isNotEmpty((Collection)addDto.getCustomerClassIds())) {
            ArrayList customerClasses = new ArrayList();
            addDto.getCustomerClassIds().forEach(bean -> {
                RebateUseRuleSearchDto.CustomerClass customerType = new RebateUseRuleSearchDto.CustomerClass();
                customerType.setCustomerClassId(bean);
                customerClasses.add(customerType);
            });
            searchDto.setCustomerClasses(customerClasses);
        }
        if (CollectionUtils.isNotEmpty((Collection)addDto.getBlacklistItem())) {
            ArrayList blackItems = new ArrayList();
            addDto.getBlacklistItem().forEach(bean -> {
                RebateUseRuleSearchDto.BlackItem blackItem = new RebateUseRuleSearchDto.BlackItem();
                blackItem.setItemId(bean.getItemId());
                blackItem.setSkuId(bean.getSkuId());
                blackItems.add(blackItem);
            });
            searchDto.setBlackItems(blackItems);
        }
        return searchDto;
    }

    private void updateSearchData(RebateUseRuleSearchDto searchDto) {
        IndexDocumentVo doc = this.newInstance();
        List<IndexDocContentVo> indexDocContents = this.getIndexDocContents(searchDto);
        doc.setContents(indexDocContents);
        this.logger.info("\u4fee\u6539\u89c4\u5219\u7d22\u5f15\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)doc));
        this.searchIndexService.updateData(doc);
    }

    private void deleteSearchByIndexId(String id) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(id);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u5220\u9664\u89c4\u5219\u7d22\u5f15\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.deleteData(indexDocumentVo);
    }

    private List<Long> getChildrenCustomerGroupIds(Long parentGroupId) {
        Map<Long, List<CustomerGroupRespDto>> customerGroupRespDtoMap;
        ArrayList groupIds = Lists.newArrayList();
        CustomerGroupQueryReqDto customerGroupQueryReqDto = new CustomerGroupQueryReqDto();
        customerGroupQueryReqDto.setTenantId(this.context.tenantId());
        customerGroupQueryReqDto.setInstanceId(this.context.instanceId());
        PageInfo pageInfoRestResponse = (PageInfo)this.customerGroupQueryApi.queryByPage(customerGroupQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)).getData();
        if (null != pageInfoRestResponse && CollectionUtils.isNotEmpty((Collection)pageInfoRestResponse.getList()) && null != (customerGroupRespDtoMap = pageInfoRestResponse.getList().stream().collect(Collectors.groupingBy(bean -> null == bean.getParentGroupId() ? 0L : bean.getParentGroupId())))) {
            this.assembleChildrenCustomerGroupId(customerGroupRespDtoMap, parentGroupId, groupIds);
        }
        return groupIds;
    }

    public void assembleChildrenCustomerGroupId(Map<Long, List<CustomerGroupRespDto>> customerGroupRespDtoMap, Long parentGroupId, List<Long> groupIds) {
        List<CustomerGroupRespDto> customerGroupRespDtos = customerGroupRespDtoMap.get(parentGroupId);
        if (CollectionUtils.isNotEmpty(customerGroupRespDtos)) {
            customerGroupRespDtos.stream().forEach(bean -> {
                groupIds.add(bean.getId());
                this.assembleChildrenCustomerGroupId(customerGroupRespDtoMap, bean.getId(), groupIds);
            });
        }
    }

    private List<Long> getParentGCustomerGroupIds(Long groupId) {
        ArrayList groupIds = Lists.newArrayList();
        if (groupId == null) {
            return groupIds;
        }
        CustomerGroupQueryReqDto customerGroupQueryReqDto = new CustomerGroupQueryReqDto();
        customerGroupQueryReqDto.setTenantId(this.context.tenantId());
        customerGroupQueryReqDto.setInstanceId(this.context.instanceId());
        PageInfo pageInfoRestResponse = (PageInfo)this.customerGroupQueryApi.queryByPage(customerGroupQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)).getData();
        if (null != pageInfoRestResponse && CollectionUtils.isNotEmpty((Collection)pageInfoRestResponse.getList())) {
            HashMap<Long, CustomerGroupRespDto> customerGroupMap = new HashMap<Long, CustomerGroupRespDto>();
            pageInfoRestResponse.getList().forEach(customerGroupRespDto -> customerGroupMap.put(null == customerGroupRespDto.getParentGroupId() ? 0L : customerGroupRespDto.getParentGroupId(), (CustomerGroupRespDto)customerGroupRespDto));
            groupIds.add(groupId);
            CustomerGroupRespDto customerGroupRespDto2 = (CustomerGroupRespDto)this.customerGroupQueryApi.queryById(groupId).getData();
            if (null == customerGroupRespDto2) {
                throw new BizException("\u5ba2\u6237\u5206\u7ec4\u4e0d\u5b58\u5728");
            }
            this.assembleParentGCustomerGroupIds(groupIds, customerGroupMap, customerGroupRespDto2.getParentGroupId());
        }
        return groupIds;
    }

    private void assembleParentGCustomerGroupIds(List<Long> ids, Map<Long, CustomerGroupRespDto> customerGroupMap, Long parentId) {
        if (parentId == null || parentId == 0L) {
            return;
        }
        CustomerGroupRespDto groupRespDto = customerGroupMap.get(parentId);
        if (null != groupRespDto) {
            ids.add(groupRespDto.getId());
            this.assembleParentGCustomerGroupIds(ids, customerGroupMap, groupRespDto.getParentGroupId());
        }
    }

    private List<String> getChildrenAreaCodes(String parentAreaCode) {
        Map<String, List<AreaGroupRespDto>> areaGroupRespDtoMap;
        ArrayList childrenAreaCodes = Lists.newArrayList();
        HashMap<String, Long> filterMap = new HashMap<String, Long>();
        filterMap.put("tenantId", this.context.tenantId());
        filterMap.put("instanceId", this.context.instanceId());
        PageInfo pageInfo = (PageInfo)this.areaGroupQueryApi.queryByPage(JSONObject.toJSONString(filterMap), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)).getData();
        if (null != pageInfo && CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) && null != (areaGroupRespDtoMap = pageInfo.getList().stream().collect(Collectors.groupingBy(bean -> null == bean.getParentCode() ? "0" : bean.getParentCode())))) {
            this.assembleChildrenAreaCode(areaGroupRespDtoMap, parentAreaCode, childrenAreaCodes);
        }
        return childrenAreaCodes;
    }

    private void assembleChildrenAreaCode(Map<String, List<AreaGroupRespDto>> areaGroupRespDtoMap, String parentCode, List<String> childrenAreaCodes) {
        List<AreaGroupRespDto> areaGroupRespDtos = areaGroupRespDtoMap.get(parentCode);
        if (CollectionUtils.isNotEmpty(areaGroupRespDtos)) {
            areaGroupRespDtos.stream().forEach(bean -> {
                childrenAreaCodes.add(bean.getCode());
                this.assembleChildrenAreaCode(areaGroupRespDtoMap, bean.getCode(), childrenAreaCodes);
            });
        }
    }

    private IndexDocumentVo newInstance() {
        return new IndexDocumentVo("rebate_use_rule_" + this.globalProfile, "rebate_use_rule");
    }
}

