/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.SettleItemReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.SettleItemRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.ISettleItemService;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.SettleItemDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.SettleItemEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.vo.SettleItemStatisticVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SettleItemServiceImpl
implements ISettleItemService {
    @Resource
    private SettleItemDas settleItemDas;

    @Override
    public Long addSettleItem(SettleItemReqDto addReqDto) {
        SettleItemEo settleItemEo = new SettleItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)settleItemEo);
        this.settleItemDas.insert((BaseEo)settleItemEo);
        return settleItemEo.getId();
    }

    @Override
    public void modifySettleItem(SettleItemReqDto modifyReqDto) {
        SettleItemEo settleItemEo = new SettleItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)settleItemEo);
        this.settleItemDas.updateSelective((BaseEo)settleItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSettleItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.settleItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SettleItemRespDto queryById(Long id) {
        SettleItemEo settleItemEo = (SettleItemEo)this.settleItemDas.selectByPrimaryKey(id);
        SettleItemRespDto settleItemRespDto = new SettleItemRespDto();
        DtoHelper.eo2Dto((BaseEo)settleItemEo, (BaseVo)settleItemRespDto);
        return settleItemRespDto;
    }

    @Override
    public PageInfo<SettleItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SettleItemReqDto settleItemReqDto = (SettleItemReqDto)JSON.parseObject((String)filter, SettleItemReqDto.class);
        SettleItemEo settleItemEo = new SettleItemEo();
        DtoHelper.dto2Eo((BaseVo)settleItemReqDto, (BaseEo)settleItemEo);
        PageInfo eoPageInfo = this.settleItemDas.selectPage((BaseEo)settleItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SettleItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public SettleItemStatisticVo statisticByPreSettleId(Long preSettlementId) {
        return this.settleItemDas.statisticByPreSettleId(preSettlementId);
    }

    @Override
    public boolean isOrderNoExists(String orderNo) {
        SettleItemEo queryEo = new SettleItemEo();
        queryEo.setOrderNo(orderNo);
        List settleItemEoList = this.settleItemDas.selectList((BaseEo)queryEo);
        return !CollectionUtils.isEmpty((Collection)settleItemEoList);
    }

    @Override
    public int batchSave(List<SettleItemEo> settleItemList) {
        return this.settleItemDas.insertBatch(settleItemList);
    }
}

