/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.export;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.impl.export.AbstractDataExport;
import com.dtyunxi.yundt.cube.center.rebate.biz.vo.RebateBalanceExportVo;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.BalanceDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.BalanceEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RebateBalanceExport
extends AbstractDataExport<RebateBalanceExportVo> {
    private IContext context;
    private BalanceDas balanceDas;
    private BalanceQueryReqDto balanceQueryReqDto;

    public RebateBalanceExport(String exportName, String suffix, IObjectStorageService objectStorageService, BalanceDas balanceDas, String filter, IContext context) {
        super(exportName, suffix, objectStorageService);
        this.balanceDas = balanceDas;
        this.context = context;
        BalanceQueryReqDto balanceQueryReqDto = (BalanceQueryReqDto)JSON.parseObject((String)filter, BalanceQueryReqDto.class);
        this.balanceQueryReqDto = null == balanceQueryReqDto ? new BalanceQueryReqDto() : balanceQueryReqDto;
    }

    @Override
    protected List<RebateBalanceExportVo> findExportDataList(Integer pageSize, Integer pageIndex) {
        ExtQueryChainWrapper filter = this.balanceDas.filter(true);
        if (StringUtils.isNotEmpty((CharSequence)this.balanceQueryReqDto.getUserName())) {
            filter = (ExtQueryChainWrapper)filter.and(warp -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)warp.like((Object)"user_name", (Object)this.balanceQueryReqDto.getUserName());
            });
        }
        if (this.balanceQueryReqDto.getOrganizationId() != null) {
            filter = (ExtQueryChainWrapper)filter.and(warp -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)warp.eq((Object)"organization_id", (Object)this.balanceQueryReqDto.getOrganizationId());
            });
        }
        filter = (ExtQueryChainWrapper)filter.orderByDesc((Object)"update_time");
        PageInfo page = filter.page(pageIndex, pageSize);
        for (BalanceEo eo : page.getList()) {
            BigDecimal balance = this.balanceDas.selectActualBalanceByUserId(eo.getUserId().longValue());
            eo.setBalance(balance);
        }
        ArrayList dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)page.getList(), RebateBalanceExportVo.class);
        return dtoList;
    }
}

