/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.scheduler;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.BalanceDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.RebateDetailDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.BalanceEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RebateDetailEo;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RebateExpiredHandle {
    private static Logger logger = LoggerFactory.getLogger(RebateExpiredHandle.class);
    @Resource
    private OrderDas orderDas;
    @Resource
    private BalanceDas balanceDas;
    @Resource
    private RebateDetailDas rebateDetailDas;
    @Resource
    private ILockService lockService;

    public void execute(OrderEo orderEo) {
        if (Objects.equals(orderEo.getStatus(), RebateOrderStatusEnum.EXPIRED.getCode())) {
            logger.info("[\u8fd4\u5229\u5355\u8fc7\u671f],\u5e42\u7b49\u5904\u7406\u5df2\u7ecf\u5931\u6548\u8fc7\u4e86,\u8fd4\u5229\u5355\u53f7\uff1a{}", (Object)orderEo.getRebateNo());
            return;
        }
        if (orderEo.getBalance().compareTo(BigDecimal.ZERO) != 0) {
            Mutex lock = this.lockService.lock(this.getClass().getSimpleName(), "rebate_balance_account_lock:" + orderEo.getRebateAccountNo(), 2000, 1000, TimeUnit.MILLISECONDS);
            try {
                this.process(orderEo);
                this.lockService.unlock(lock);
            }
            catch (Exception e) {
                logger.info("\u8fd4\u5229\u5355\uff1a{}\uff0c\u5904\u7406\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:{}", (Object)orderEo.getRebateNo(), (Object)e.getMessage());
                throw e;
            }
            finally {
                this.lockService.unlock(lock);
            }
        }
    }

    private void process(OrderEo orderEo) {
        logger.info("delay_message_orderEo: {}", (Object)JSON.toJSONString((Object)orderEo));
        BalanceEo queryBalanceEo = new BalanceEo();
        queryBalanceEo.setRebateAccountNo(orderEo.getRebateAccountNo());
        BalanceEo balanceEo = (BalanceEo)this.balanceDas.selectOne((BaseEo)queryBalanceEo);
        if (balanceEo == null) {
            return;
        }
        int i = this.balanceDas.releaseBalanceByCAS(balanceEo.getId(), balanceEo.getVersion(), orderEo.getBalance().negate());
        if (i == 0) {
            throw new BizException("\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        RebateDetailEo rebateDetailEo = new RebateDetailEo();
        rebateDetailEo.setBalanceSnapshot(balanceEo.getBalance().add(orderEo.getBalance().negate()));
        rebateDetailEo.setBusinessNo(orderEo.getRebateNo());
        rebateDetailEo.setRebateAccountNo(orderEo.getRebateAccountNo());
        rebateDetailEo.setUserId(orderEo.getUserId());
        rebateDetailEo.setUserType(orderEo.getUserType());
        rebateDetailEo.setUserName(orderEo.getUserName());
        rebateDetailEo.setChangeAmount(orderEo.getBalance().negate());
        rebateDetailEo.setType(RebateTypeEnum.FAILURE.getType() + "");
        rebateDetailEo.setExpiredTime(null);
        this.rebateDetailDas.insert((BaseEo)rebateDetailEo);
        OrderEo updateEo = new OrderEo();
        updateEo.setId(orderEo.getId());
        updateEo.setStatus(RebateOrderStatusEnum.EXPIRED.getCode());
        this.orderDas.updateSelective((BaseEo)updateEo);
    }
}

