/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.scheduler.event;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.scheduler.RebateExpiredHandle;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.OrderDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="rebateExpiredExtScheduler")
@Scope(value="prototype")
public class RebateExpiredExtSchedulerEvent
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(RebateExpiredExtSchedulerEvent.class);
    @Resource
    private RebateExpiredHandle rebateExpiredHandle;
    @Resource
    private OrderDas orderDas;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("[\u8fd4\u5229\u5355\u8fc7\u671f],\u8fd4\u5229\u5355\u8fc7\u671f\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c\uff0c\u8c03\u5ea6\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)taskMsg));
    }

    public boolean execute(TaskMsg taskMsg) {
        Long orderId = Long.parseLong(taskMsg.getContent());
        try {
            OrderEo orderEo = new OrderEo();
            orderEo.setId(orderId);
            orderEo = (OrderEo)this.orderDas.selectOne((BaseEo)orderEo);
            if (orderEo == null) {
                logger.info("[\u8fd4\u5229\u5355\u8fc7\u671f]\uff0c\u8fd4\u5229\u5355\u4e0d\u5b58\u5728\uff1a{}", (Object)orderId);
            }
            this.rebateExpiredHandle.execute(orderEo);
        }
        catch (Exception e) {
            logger.error("[\u8fd4\u5229\u5355\u8fc7\u671f]\uff0c\u62a5\u9519\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        logger.info("[\u8fd4\u5229\u5355\u8fc7\u671f],\u8fd4\u5229\u5355\u8fc7\u671f\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u6267\u884c");
    }
}

