/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.service.scheduler.event;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PreSettlementQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicyService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPolicySettleRuleService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.IPreSettlementService;
import com.dtyunxi.yundt.cube.center.rebate.biz.service.ISettleItemService;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.DateUtil;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.PreSettlementEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="rebateSettleScheduler")
@Scope(value="prototype")
public class RebateSettleSchedulerEvent
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(RebateSettleSchedulerEvent.class);
    @Resource
    private IPolicyService policyService;
    @Resource
    private IPolicySettleRuleService policySettleRuleService;
    @Resource
    private IPreSettlementService preSettlementService;
    @Resource
    private ISettleItemService settleItemService;
    @Resource
    private IOrderService orderService;
    @Value(value="${icomb.common.rebate.settle.period.beforeDay:3}")
    private Integer fewDayBefore;

    public void before(TaskMsg taskMsg) {
        logger.info("");
    }

    public boolean execute(TaskMsg taskMsg) {
        logger.info("\u751f\u6210\u8fd4\u5229\u653f\u7b56\u7684\uff1aTaskMsg={}", (Object)JSON.toJSONString((Object)taskMsg));
        Date curDate = new Date();
        logger.info("\u5f00\u59cb\u751f\u6210\u8fd4\u5229\u653f\u7b56\u7684\u8fd4\u5229\u5355 curDate={}", (Object)curDate);
        PreSettlementQueryReqDto query = new PreSettlementQueryReqDto();
        try {
            String[] shardParams = taskMsg.getContent().split("/");
            if (shardParams != null && shardParams.length > 1) {
                query.setShardNo(Integer.valueOf(shardParams[0]));
                query.setShardTotal(Integer.valueOf(shardParams[1]));
            }
            Date settleDateStart = DateUtil.setDateStart(DateUtil.getDateBefore(curDate, this.fewDayBefore));
            Date settleDateEnd = DateUtil.setDateEnd(DateUtil.getDateBefore(curDate, 1));
            query.setSettleDateStart(settleDateStart);
            query.setSettleDateEnd(settleDateEnd);
            logger.info("\u67e5\u8be2\u751f\u6210\u8fd4\u5229\u5355\u7684\u653f\u7b56\u5ba2\u6237\u53c2\u6570\u662f:settleDateStart={},settleDateEnd={}", (Object)settleDateStart, (Object)settleDateEnd);
            List<PreSettlementEo> policyUserList = this.preSettlementService.selectUnSettlePolicyUser(query);
            for (PreSettlementEo policyUser : policyUserList) {
                try {
                    boolean bl = this.preSettlementService.genUserRebateOrder(policyUser);
                }
                catch (Exception e) {
                    logger.error("genUserRebateOrder error: userId = {}, {}", (Object)policyUser.getUserId(), (Object)e.getMessage());
                }
            }
            Integer policyUserSize = policyUserList == null ? 0 : policyUserList.size();
            logger.info("\u4efb\u52a1\u5904\u7406\u6709\u8fd4\u5229\u5355\u7684\u5ba2\u6237={}", (Object)policyUserSize);
        }
        catch (Exception e) {
            logger.error("\u8fd4\u5229\u5355\u8ba1\u7b97\u9519\u8bef\uff1a{}", (Throwable)e);
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        logger.info("\u751f\u6210\u8fd4\u5229\u653f\u7b56\u7684\u8fd4\u5229\u5355\u7ed3\u675f");
    }
}

