/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static String YYYYMMDD_PATTERN = "yyyy-MM-dd";
    public static String EXPORT_PATTERN = "yyyy/MM/dd HH:mm:ss";

    public static String getDateFormat(Date date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static Date parseDate(String dateStr, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        return date;
    }

    public static Date getMonthBegin(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getMonthBegin(Date date, int i) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) + i);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getMonthEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getQuarterBegin(Date cycleBegin, int x) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(cycleBegin);
        calendar.set(2, calendar.get(2) + x * 3);
        int currentMonth = calendar.get(2) + 1;
        if (currentMonth >= 1 && currentMonth <= 3) {
            calendar.set(2, 0);
        } else if (currentMonth >= 4 && currentMonth <= 6) {
            calendar.set(2, 3);
        } else if (currentMonth >= 7 && currentMonth <= 9) {
            calendar.set(2, 6);
        } else if (currentMonth >= 10 && currentMonth <= 12) {
            calendar.set(2, 9);
        }
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getQuarterEnd(Date curCycleStart) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curCycleStart);
        int currentMonth = calendar.get(2) + 1;
        if (currentMonth >= 1 && currentMonth <= 3) {
            calendar.set(2, 2);
            calendar.set(5, 31);
        } else if (currentMonth >= 4 && currentMonth <= 6) {
            calendar.set(2, 5);
            calendar.set(5, 30);
        } else if (currentMonth >= 7 && currentMonth <= 9) {
            calendar.set(2, 8);
            calendar.set(5, 30);
        } else if (currentMonth >= 10 && currentMonth <= 12) {
            calendar.set(2, 11);
            calendar.set(5, 31);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getYearBegin(Date cycleBegin, int x) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(cycleBegin);
        calendar.set(1, calendar.get(1) + x);
        calendar.set(2, calendar.getActualMinimum(2));
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getYearEnd(Date curCycleStart) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curCycleStart);
        calendar.set(2, calendar.getActualMaximum(2));
        calendar.set(5, 31);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date setDateStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date setDateEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getDateBefore(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.get(5) - day);
        return calendar.getTime();
    }

    public static Date getDateAfter(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.get(5) + day);
        return calendar.getTime();
    }

    public static Date flexibleDateFormat(String date) {
        Date result = null;
        ArrayList<SimpleDateFormat> simpleDateFormatList = new ArrayList<SimpleDateFormat>();
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
        simpleDateFormatList.add(sdf);
        SimpleDateFormat day1 = new SimpleDateFormat("yyyy/MM/dd");
        simpleDateFormatList.add(day1);
        SimpleDateFormat day = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormatList.add(day);
        SimpleDateFormat all = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        simpleDateFormatList.add(all);
        SimpleDateFormat china = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5hh:mm:ss");
        simpleDateFormatList.add(china);
        SimpleDateFormat china1 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 hh:mm:ss");
        simpleDateFormatList.add(china1);
        SimpleDateFormat china2 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        simpleDateFormatList.add(china2);
        for (int i = 0; i < simpleDateFormatList.size(); ++i) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)simpleDateFormatList.get(i);
            try {
                result = simpleDateFormat.parse(date);
                break;
            }
            catch (Exception e) {
                if (i != simpleDateFormatList.size() - 1) continue;
                return null;
            }
        }
        return result;
    }

    public static String date2Cron(Date date) {
        String format = "ss mm HH dd MM ? yyyy";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String cron = null;
        if (date != null) {
            cron = sdf.format(date);
        }
        return cron;
    }

    public static void main(String[] args) throws ParseException {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date1 = sdf.parse("2021-03-32 00:00:00");
        for (int i = 0; i < 41; ++i) {
            Date curYearBegin = DateUtil.getYearBegin(date1, i);
            Date curYearEnd = DateUtil.getYearEnd(curYearBegin);
            System.out.println("curMonthBegin = " + sdf.format(curYearBegin));
            System.out.println("curMonthBegin = " + sdf.format(curYearEnd));
        }
    }
}

