/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.biz.util;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RebateUtil {
    private static int maxPerMSECSize = 99999;
    @Autowired
    ICacheService cacheService;
    private static RebateUtil rebateUtil;
    private static final String REBATE_ACCOUNT_NO = "REBATEACCOUNTNO";
    private static final String REBATE_POLICY_NO = "REBATE_POLICY_NO";
    private static final Integer STR_FORMAT_10;
    private static final Integer STR_FORMAT_100;
    private static final Integer STR_FORMAT_1000;
    private static final Integer STR_FORMAT_10000;

    @PostConstruct
    public void init() {
        rebateUtil = this;
        RebateUtil.rebateUtil.cacheService = this.cacheService;
    }

    public static String generateRebateAccountNo(String prefix) {
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        String timeStr = String.valueOf(nowLong);
        Long result = RebateUtil.rebateUtil.cacheService.incr(REBATE_ACCOUNT_NO);
        Long mod = result % (long)maxPerMSECSize;
        String resultNo = "" + mod;
        if (mod < (long)STR_FORMAT_10.intValue()) {
            resultNo = "0000" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            resultNo = "000" + mod;
        } else if (mod >= (long)STR_FORMAT_100.intValue() && mod < (long)STR_FORMAT_1000.intValue()) {
            resultNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_1000.intValue() && mod < (long)STR_FORMAT_10000.intValue()) {
            resultNo = "0" + mod;
        }
        return prefix + timeStr + resultNo;
    }

    public static String generateRebatePolicyNo(String prefix) {
        StringBuilder code = new StringBuilder();
        String timeStr = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        code.append(prefix).append(timeStr);
        Long activityCodeNo = RebateUtil.rebateUtil.cacheService.incr(REBATE_POLICY_NO);
        Long model = activityCodeNo % 999L;
        if (model < 10L) {
            code.append("00").append(model);
        } else if (model < 100L) {
            code.append("0").append(model);
        } else {
            code.append(model);
        }
        int romNum = RandomUtils.nextInt((int)1, (int)999);
        if (romNum < 10) {
            code.append("00").append(romNum);
        } else if (romNum < 100) {
            code.append("0").append(romNum);
        } else {
            code.append(romNum);
        }
        return code.toString();
    }

    static {
        STR_FORMAT_10 = 10;
        STR_FORMAT_100 = 100;
        STR_FORMAT_1000 = 1000;
        STR_FORMAT_10000 = 10000;
    }
}

