/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.dao.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.OrderDetailVO;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateOrderCountReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateOrderCountRespDto;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.StdOrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.mapper.OrderMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository
public class OrderDas
extends AbstractBaseDas<OrderEo, Long> {
    @Resource
    private OrderMapper orderMapper;

    public List<OrderEo> getEffectOrderEos(Long userId) {
        Date date = new Date();
        return this.orderMapper.getEffectOrderEos(date, RebateOrderStatusEnum.ISSUED.getCode(), userId);
    }

    public int useBalanceById(Long id, BigDecimal useAmount) {
        return this.orderMapper.useBalanceById(id, useAmount);
    }

    public int releaseBalanceById(Long id, BigDecimal releaseAmount, Integer version, Integer type) {
        return this.orderMapper.releaseBalanceById(id, releaseAmount, version, type);
    }

    public Map<String, List<OrderEo>> getOrderMapByOrderNos(Set<String> rebateNoCollect) {
        OrderEo selectItemOrder = new OrderEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"rebate_no", rebateNoCollect));
        selectItemOrder.setSqlFilters(sqlFilterList);
        selectItemOrder.setOrderBy("effect_end_time");
        List orderEos = this.select((BaseEo)selectItemOrder);
        Map<String, List<OrderEo>> orderEoMapGroupByRebateNo = orderEos.stream().collect(Collectors.groupingBy(StdOrderEo::getRebateNo, Collectors.toList()));
        return orderEoMapGroupByRebateNo;
    }

    public List<OrderDetailVO> selectPageListById(Long id, Long tenantId, Long instanceId) {
        return this.orderMapper.selectPageListById(id, tenantId, instanceId);
    }

    public Integer existOrderByCategoryIds(List<Long> categoryIds) {
        return this.orderMapper.existOrderByCategoryIds(categoryIds);
    }

    public List<OrderEo> selectExpiredOrderEos() {
        Date date = new Date();
        return this.orderMapper.selectExpiredOrderEos(date, RebateOrderStatusEnum.ISSUED.getCode());
    }

    public int useBalanceByCAS(Long id, Integer version, BigDecimal useAmount, Integer type) {
        return this.orderMapper.useBalanceByCAS(id, version, useAmount, type);
    }

    public RebateOrderCountRespDto queryOrderCount(RebateOrderCountReqDto reqDto) {
        return this.orderMapper.queryOrderCount(reqDto);
    }
}

