/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.dao.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.UserTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.BalanceRespDto;
import com.dtyunxi.yundt.cube.center.rebate.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.BalanceEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.mapper.BalanceMapper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class BalanceDas
extends AbstractBaseDas<BalanceEo, Long> {
    @Resource
    private BalanceMapper balanceMapper;

    public BalanceEo queryCustomerAccountByUserId(Long customerId) {
        BalanceEo queryEo = new BalanceEo();
        queryEo.setUserType(UserTypeEnum.CUSTOMER.toCode());
        queryEo.setUserId(customerId);
        return (BalanceEo)this.selectOne((BaseEo)queryEo);
    }

    public int useBalanceByUserId(Long userId, BigDecimal payAmount) {
        BalanceEo selectItemBalance = new BalanceEo();
        selectItemBalance.setUserId(userId);
        List balanceEos = this.selectList((BaseEo)selectItemBalance);
        if (CollectionUtils.isEmpty((Collection)balanceEos)) {
            return 0;
        }
        BalanceEo balanceEo = (BalanceEo)balanceEos.get(0);
        return this.useBalance(balanceEo.getId(), payAmount);
    }

    public int useBalance(Long accountId, BigDecimal payAmount) {
        this.removeCache(accountId);
        return this.balanceMapper.useBalance(accountId, payAmount);
    }

    public int releaseBalance(Long accountId, BigDecimal payAmount) {
        return this.balanceMapper.releaseBalance(accountId, payAmount);
    }

    public int useBalanceWithNegative(Long accountId, BigDecimal payAmount) {
        this.removeCache(accountId);
        return this.balanceMapper.useBalanceWithNegative(accountId, payAmount);
    }

    public List<BalanceRespDto> selectListByCustomerIds(List<Long> customerIds) {
        return this.balanceMapper.selectListByCustomerIds(customerIds);
    }

    public BigDecimal selectActualBalanceByUserId(long userId) {
        return this.balanceMapper.selectActualBalanceByUserId(userId);
    }

    public int useBalanceByCAS(Long userId, Integer version, BigDecimal payAmount) {
        return this.balanceMapper.useBalanceByCAS(userId, payAmount, version);
    }

    public int releaseBalanceByCAS(Long accountId, Integer version, BigDecimal rechargeAmount) {
        return this.balanceMapper.releaseBalanceByCAS(accountId, version, rechargeAmount);
    }
}

