/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.rebate.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.IPolicyApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.PolicyEsDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicyAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicyAuditReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicyModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.PolicyQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyConstantsDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.PolicyListResDto;
import com.dtyunxi.yundt.cube.center.rebate.api.query.IPolicyQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/policy"})
public class PolicyRest
implements IPolicyApi,
IPolicyQueryApi {
    @Resource
    private IPolicyApi policyApi;
    @Resource
    private IPolicyQueryApi policyQueryApi;

    public RestResponse<Long> addPolicy(@Valid @RequestBody PolicyAddReqDto reqDto) {
        return this.policyApi.addPolicy(reqDto);
    }

    public RestResponse<Void> modifyPolicy(@Valid @RequestBody PolicyModifyReqDto reqDto) {
        return this.policyApi.modifyPolicy(reqDto);
    }

    public RestResponse<Void> toVoidPolicy(@PathVariable(value="id") Long id) {
        return this.policyApi.toVoidPolicy(id);
    }

    public RestResponse<Void> audit(@PathVariable(value="id") Long id, @Valid @RequestBody PolicyAuditReqDto reqDto) {
        return this.policyApi.audit(id, reqDto);
    }

    public RestResponse<Void> submit(Long id) {
        return this.policyApi.submit(id);
    }

    public RestResponse<PolicyDetailRespDto> queryPolicyById(@PathVariable(value="id") Long id) {
        return this.policyQueryApi.queryPolicyById(id);
    }

    public RestResponse<PageInfo<PolicyListResDto>> queryPolicyByPage(@SpringQueryMap PolicyQueryReqDto reqDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.policyQueryApi.queryPolicyByPage(reqDto, pageNum, pageSize);
    }

    public RestResponse<PolicyConstantsDto> constantList() {
        return this.policyQueryApi.constantList();
    }

    public RestResponse<PolicyEsDto> queryPolicyEs(Long custId, Long itemId, Date orderTime, Long skuId) {
        return this.policyQueryApi.queryPolicyEs(custId, itemId, orderTime, skuId);
    }
}

