/*
 * @(#)StdCustomerAreaEo 1.0 2021-08-24
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import java.util.Date;

/**
 * 客户区域表
 *
 * @author 惜笔
 * @version 1.0.0
 * @date 2021-08-24 14:28
 */
public class StdCustomerAreaEo extends CubeBaseEo {

    /**
     * 顶级id,第一层的顶级id为主键id，其他层级的为第一层的主键id。使用场景，如查询广东区下的所有区域，
     * 则根据广东区该条数据的topId和level，直接限制top_id=顶级id and level<等级
     */
    @Column(name="top_id")
    private Long topId;

    /**
     * 编码
     */
    @Column
    private String code;

    /**
     * 父编码
     */
    @Column
    private String parentCode;

    /**
     * 区域自定义编码
     */
    @Column(name = "area_code")
    private String areaCode;

    /**
     * 区域名称
     */
    @Column
    private String name;

    /**
     *  组织信息ID
     */
    @Column(name = "org_info_id")
    private Long orgInfoId;

    /**
     *  层级，1-第一层；2-第二层
     */
    @Column(name = "level")
    private Integer level;

    /**
     *  排序值
     */
    @Column(name = "sort")
    private Integer sort;

    /**
     *  结束时间
     */
    @Column(name = "end_date")
    private Date endDate;

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOrgInfoId() {
        return orgInfoId;
    }

    public void setOrgInfoId(Long orgInfoId) {
        this.orgInfoId = orgInfoId;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Long getTopId() {
        return topId;
    }

    public void setTopId(Long topId) {
        this.topId = topId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }
}
