package com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer; /**
 * @(#)CustomerGroupEo.java 1.0 2021-05-08 15:00:35
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
* 客户可买范围
*
* @author zhuiming
* @Date : 2021-08-27
*/
@Table(name="cs_customer_buy_scope")
public class StdCustomerBuyScopeEo extends CubeBaseEo{


    /**
     *  客户ID
     */
    @Column(name = "customer_id")
    private Long customerId;
    /**
     *  业务ID（类目，品牌，商品sku，禁止的商品sku等ID）
     */
    @Column(name = "business_id")
    private Long businessId;
    /**
     * 业务类型（CATEGORY：类目、BRAND：品牌、SKU：商品sku、BANSKU：禁止的商品sku）
     */
    @Column(name = "business_type")
    private String businessType;

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
}