package com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer;

import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * @Description: 客商导出操作记录实体
 * @Author: xuhuaqiang
 * @Date: 2020年10月13日
 * @Version: 0.1.0
 */
@Table(name = "cs_customer_export_record")
public class StdCustomerExportRecordEo extends BaseEo {

    /**
     * 导出卡数量
     */
    @Column(name = "num")
    private Integer num;

    /**
     * 导出文件名
     */
    @Column(name = "file_name")
    private String fileName;
    /**
     * 导出文件Url
     */
    @Column(name = "url")
    private String url;

    /**
     * 导出类型：1-供应商信息列表；2-客户信息列表
     */
    @Column(name = "type")
    private Integer type;

    /**
     * 导出备注
     */
    @Column(name = "reason")
    private String reason;

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public static StdCustomerExportRecordEo newInstance(){
        return (StdCustomerExportRecordEo) BaseEo.newInstance(StdCustomerExportRecordEo.class);
    }
}
