package com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer;

import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 客户信息
 *
 * @author zhuiming.xhq@dtyunxi.com
 * @since 0.6.0
 */
@Table(name = "cs_customer")
public class StdCustomerEo extends BaseEo {

    /**
     *  组织信息ID
     */
    @Column(name = "org_info_id")
    private Long orgInfoId;

    /**
     * 用户ID
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     *  名称
     */
    @Column(name = "name")
    private String name;

    /**
     *  编号
     */
    @Column(name = "code")
    private String code;

    /**
     * 客户类型ID
     */
    @Column(name = "customer_type_id")
    private Long customerTypeId;
    /**
     * 父客户ID
     */
    @Column(name = "parent_customer_id")
    private Long parentCustomerId;

    /**
     * 区域ID
     */
    @Column(name = "region_id")
    private Long regionId;
    /**
     * 区域code
     */
    @Column(name = "region_code")
    private String regionCode;

    /**
     *  省份编码
     */
    @Column(name = "province_code")
    private String provinceCode;

    /**
     *  省份
     */
    @Column(name = "province")
    private String province;

    /**
     *  地市编码
     */
    @Column(name = "city_code")
    private String cityCode;

    /**
     *  地市
     */
    @Column(name = "city")
    private String city;

    /**
     *  区编码
     */
    @Column(name = "county_code")
    private String countyCode;

    /**
     *  区
     */
    @Column(name = "county")
    private String county;

    /**
     *  国家
     */
    @Column(name = "country")
    private String country;

    /**
     *  详细地址
     */
    @Column(name = "address")
    private String address;

    /**
     *  业务员
     */
    @Column(name = "salesman_id")
    private Long salesmanId;

    /**
     *  备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     *  状态
     */
    @Column(name = "status_id")
    private Long statusId;

    /**
     * 客户分组id
     */
    @Column(name = "customer_group_id")
    private Long customerGroupId;

    /**
     * 客户级别id
     */
    @Column(name = "level_id")
    private Long levelId;

    /**
     * 所属商家（实际存的是所属商家对应的组织即上游组织）
     */
    @Column(name = "merchant_id")
    private Long merchantId;

    /**
     * 客户类型（1：品牌商，2：经销商，3：零售商）
     */
    @Column(name = "type")
    private Integer type;

    /**
     * 审核状态（WAIT_AUDIT：待审核、AUDIT_REJECT：审核不通过、AUDIT_PASS：审核通过、INVALID：作废、DRAFT：草稿）
     */
    @Column(name = "audit_status")
    private String auditStatus;

    /**
     * 审核说明
     */
    @Column(name = "audit_desc")
    private String auditDesc;

    /**
     * 入驻状态（1：未入驻、2：申请中、3：已入驻(启用)、4：禁用）
     */
    @Column(name = "settle_status")
    private Integer settleStatus;

    /**
     * 审核时间
     */
    @Column(name = "audit_time")
    protected Date auditTime;


    /**
     * 客户ID
     */
    @Column(name = "third_party_id")
    private String thirdPartyId;

    /**
     * 客户简称
     */
    @Column(name = "aliasname")
    private String aliasname;

    /**
     * 第三方客户父级ID
     */
    @Column(name = "third_parent_party_id")
    private String thirdParentPartyId;

    @Column(name = "eas_code")
    private String easCode;

    @Column(name = "signing_company")
    private String signingCompany;

    /**
     * 是否认证统一社会信用代码  0否，1是
     */
    @Column(name = "if_certification")
    private Integer ifCertification;

    /**
     * 认证截止时间
     */
    @Column(name = "certification_deadline")
    private Date certificationDeadline;

    /**
     * 发货方式  1：商家发货  2：厂家发货
     */
    @Column(name = "deliver_method")
    private Integer deliverMethod;

    public Integer getDeliverMethod() {
        return deliverMethod;
    }

    public void setDeliverMethod(Integer deliverMethod) {
        this.deliverMethod = deliverMethod;
    }

    public String getSigningCompany() {
        return signingCompany;
    }

    public void setSigningCompany(String signingCompany) {
        this.signingCompany = signingCompany;
    }

    public String getEasCode() {
        return easCode;
    }

    public void setEasCode(String easCode) {
        this.easCode = easCode;
    }

    public String getThirdParentPartyId() {
        return thirdParentPartyId;
    }

    public void setThirdParentPartyId(String thirdParentPartyId) {
        this.thirdParentPartyId = thirdParentPartyId;
    }

    public String getThirdPartyId() {
        return thirdPartyId;
    }

    public void setThirdPartyId(String thirdPartyId) {
        this.thirdPartyId = thirdPartyId;
    }

    public String getAliasname() {
        return aliasname;
    }

    public void setAliasname(String aliasname) {
        this.aliasname = aliasname;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Integer getSettleStatus() {
        return settleStatus;
    }

    public void setSettleStatus(Integer settleStatus) {
        this.settleStatus = settleStatus;
    }

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getAuditDesc() {
        return auditDesc;
    }

    public void setAuditDesc(String auditDesc) {
        this.auditDesc = auditDesc;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getLevelId() {
        return levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    public Long getCustomerGroupId() {
        return customerGroupId;
    }

    public void setCustomerGroupId(Long customerGroupId) {
        this.customerGroupId = customerGroupId;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    /**
     * 设置组织信息ID
     */
    public void setOrgInfoId(Long orgInfoId){
        this.orgInfoId = orgInfoId;
    }

    /**
     * 获取组织信息ID
     */
    public Long getOrgInfoId(){
        return this.orgInfoId;
    }


    /**
     * 设置管理员ID
     */
    public void setUserId(Long userId){
        this.userId = userId;
    }

    /**
     * 获取管理员ID
     */
    public Long getUserId(){
        return this.userId;
    }


    /**
     * 设置名称
     */
    public void setName(String name){
        this.name = name;
    }

    /**
     * 获取名称
     */
    public String getName(){
        return this.name;
    }


    /**
     * 设置编号
     */
    public void setCode(String code){
        this.code = code;
    }

    /**
     * 获取编号
     */
    public String getCode(){
        return this.code;
    }


    /**
     * 设置客户类型ID
     */
    public void setCustomerTypeId(Long customerTypeId){
        this.customerTypeId = customerTypeId;
    }

    /**
     * 获取客户类型ID
     */
    public Long getCustomerTypeId(){
        return this.customerTypeId;
    }


    /**
     * 设置区域ID
     */
    public void setRegionId(Long regionId){
        this.regionId = regionId;
    }

    /**
     * 获取区域ID
     */
    public Long getRegionId(){
        return this.regionId;
    }


    /**
     * 设置省份编码
     */
    public void setProvinceCode(String provinceCode){
        this.provinceCode = provinceCode;
    }

    /**
     * 获取省份编码
     */
    public String getProvinceCode(){
        return this.provinceCode;
    }


    /**
     * 设置省份
     */
    public void setProvince(String province){
        this.province = province;
    }

    /**
     * 获取省份
     */
    public String getProvince(){
        return this.province;
    }


    /**
     * 设置地市编码
     */
    public void setCityCode(String cityCode){
        this.cityCode = cityCode;
    }

    /**
     * 获取地市编码
     */
    public String getCityCode(){
        return this.cityCode;
    }


    /**
     * 设置地市
     */
    public void setCity(String city){
        this.city = city;
    }

    /**
     * 获取地市
     */
    public String getCity(){
        return this.city;
    }


    /**
     * 设置区编码
     */
    public void setCountyCode(String countyCode){
        this.countyCode = countyCode;
    }

    /**
     * 获取区编码
     */
    public String getCountyCode(){
        return this.countyCode;
    }


    /**
     * 设置区
     */
    public void setCounty(String county){
        this.county = county;
    }

    /**
     * 获取区
     */
    public String getCounty(){
        return this.county;
    }


    /**
     * 设置详细地址
     */
    public void setAddress(String address){
        this.address = address;
    }

    /**
     * 获取详细地址
     */
    public String getAddress(){
        return this.address;
    }


    /**
     * 设置业务员
     */
    public void setSalesmanId(Long salesmanId){
        this.salesmanId = salesmanId;
    }

    /**
     * 获取业务员
     */
    public Long getSalesmanId(){
        return this.salesmanId;
    }


    /**
     * 设置备注
     */
    public void setRemark(String remark){
        this.remark = remark;
    }

    /**
     * 获取备注
     */
    public String getRemark(){
        return this.remark;
    }


    /**
     * 设置状态
     */
    public void setStatusId(Long statusId) {
        this.statusId = statusId;
    }

    /**
     * 获取状态
     */
    public Long getStatusId() {
        return this.statusId;
    }

    public Long getParentCustomerId() {
        return parentCustomerId;
    }

    public void setParentCustomerId(Long parentCustomerId) {
        this.parentCustomerId = parentCustomerId;
    }

    public Integer getIfCertification() {
        return ifCertification;
    }

    public void setIfCertification(Integer ifCertification) {
        this.ifCertification = ifCertification;
    }

    public Date getCertificationDeadline() {
        return certificationDeadline;
    }

    public void setCertificationDeadline(Date certificationDeadline) {
        this.certificationDeadline = certificationDeadline;
    }
}