/*
 * @(#)BasePriceItemEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;
import java.math.BigDecimal;
import java.util.Date;



  
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceItemEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import javax.persistence.Table;

/**
 * 商品基础价格明细(BasePriceItem)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 19:28:02
 * @since v1
 */
@Table(name="pr_base_price_item")
public class BasePriceItemEo extends StdBasePriceItemEo {

    public static BasePriceItemEo newInstance() {
        return new BasePriceItemEo();
    }

    public <DTO extends BaseVo> DTO toDto(Class<DTO> dtoClass) {
        try {
            DTO dto = dtoClass.newInstance();
            DtoHelper.eo2Dto(this, dto);
            return dto;
        }catch (Exception e){
            return null;
        }
    }
}
