/*
 * @(#)BasePriceApplyEo.java 1.0 2021-11-18
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;
import java.util.Date;



  
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceApplyEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import javax.persistence.Table;

/**
 * 基础价调价申请(BasePriceApply)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-18 09:57:24
 * @since v1
 */
@Table(name="pr_base_price_apply")
public class BasePriceApplyEo extends StdBasePriceApplyEo {

    public static BasePriceApplyEo newInstance() {
        return (BasePriceApplyEo) BaseEo.newInstance(BasePriceApplyEo.class);
    }

    public <DTO extends BaseVo> DTO toDto(Class<DTO> dtoClass) {
        try {
            DTO dto = dtoClass.newInstance();
            DtoHelper.eo2Dto(this, dto);
            return dto;
        }catch (Exception e){
            return null;
        }
    }
}
