package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;

import javax.persistence.Table;

/**
 * AuditEo对象
 *
 * @author liuji
 * @since 2021-06-30
 */
@Table(name = "pr_audit")
public class AuditEo extends StdAuditEo {

    public static AuditEo newInstance() {
        return (AuditEo) BaseEo.newInstance(AuditEo.class);
    }

    public <DTO extends BaseVo> DTO toDto(Class<DTO> dtoClass) {
        try {
            DTO dto = dtoClass.newInstance();
            DtoHelper.eo2Dto(this, dto);
            return dto;
        }catch (Exception e){
            return null;
        }
    }

}
