/*
 * @(#)BasePriceApplyItemEo.java 1.0 2021-11-18
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;



  
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceApplyItemEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import javax.persistence.Table;

/**
 * 基础价调价申请商品明细(BasePriceApplyItem)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-18 10:28:03
 * @since v1
 */
@Table(name="pr_base_price_apply_item")
public class BasePriceApplyItemEo extends StdBasePriceApplyItemEo {

    public static BasePriceApplyItemEo newInstance() {
        return (BasePriceApplyItemEo) BaseEo.newInstance(BasePriceApplyItemEo.class);
    }

    public <DTO extends BaseVo> DTO toDto(Class<DTO> dtoClass) {
        try {
            DTO dto = dtoClass.newInstance();
            DtoHelper.eo2Dto(this, dto);
            return dto;
        }catch (Exception e){
            return null;
        }
    }
}
