/*
 * @(#)PriceBasicConfigEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;



  
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceBasicConfigEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import javax.persistence.Table;

/**
 * 基础设置(PriceBasicConfig)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 19:28:26
 * @since v1
 */
@Table(name="pr_price_basic_config")
public class PriceBasicConfigEo extends StdPriceBasicConfigEo {

    public static PriceBasicConfigEo newInstance() {
        return (PriceBasicConfigEo) BaseEo.newInstance(PriceBasicConfigEo.class);
    }

    public <DTO extends BaseVo> DTO toDto(Class<DTO> dtoClass) {
        try {
            DTO dto = dtoClass.newInstance();
            DtoHelper.eo2Dto(this, dto);
            return dto;
        }catch (Exception e){
            return null;
        }
    }
}
