/*
 * @(#)PriceRejectCustomerEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;



  
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceRejectCustomerEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import javax.persistence.Table;

/**
 * 剔除客户明细(PriceRejectCustomer)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 19:30:02
 * @since v1
 */
@Table(name="pr_price_reject_customer")
public class PriceRejectCustomerEo extends StdPriceRejectCustomerEo {

    public static PriceRejectCustomerEo newInstance() {
        return (PriceRejectCustomerEo) BaseEo.newInstance(PriceRejectCustomerEo.class);
    }

    public <DTO extends BaseVo> DTO toDto(Class<DTO> dtoClass) {
        try {
            DTO dto = dtoClass.newInstance();
            DtoHelper.eo2Dto(this, dto);
            return dto;
        }catch (Exception e){
            return null;
        }
    }
}
