package com.dtyunxi.yundt.cube.center.price.dao.eo;


import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 冗余的sku价格表，只做上线初始化数据使用
 * @author  惜笔 | 林五弟
 * @date  2021/12/29 17:56
 * @version 1.0.0
 */
@Table(name = "pr_seller_sku_price")
public class SellerSkuPriceEo extends CubeBaseEo {
    /**
     * 大B客户id
     */
    @Column(name = "dealer_customer_id")
    private Long dealerCustomerId;
    /**
     * 大B组织id
     */
    @Column(name = "dealer_org_id")
    private Long dealerOrgId;
    /**
     * 小b客户名字
     */
    @Column(name = "customer_name")
    private String customerName;
    /**
     * 小b客户id
     */
    @Column(name = "customer_id")
    private Long customerId;
    /**
     * 商品组织id(品牌方组织id)
     */
    @Column(name = "item_org_id")
    private Long itemOrgId;
    /**
     * Item ID
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * SKU ID
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;
    /**
     * 零售价(建议的价格)
     */
    @Column(name = "retail_price")
    private BigDecimal retailPrice;
    /**
     * 供货价(售卖的价格)
     */
    @Column(name = "supply_price")
    private BigDecimal supplyPrice;
    /**
     * 店铺id
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 店铺名字
     */
    @Column(name = "shop_name")
    private String shopName;
    /**
     * 同步次数
     */
    @Column(name = "sync_number")
    private Integer syncNumber;
    /**
     * 组织编码code
     */
    @Column(name = "supplier_id")
    private String supplierId;
    /**
     * 客户第三方id
     */
    @Column(name = "third_party_id")
    private String thirdPartyId;
    /**
     * 长编码(商品长编码item_long_code)
     */
    @Column(name = "eas_no")
    private String easNo;

    public Long getDealerCustomerId() {
        return dealerCustomerId;
    }

    public void setDealerCustomerId(Long dealerCustomerId) {
        this.dealerCustomerId = dealerCustomerId;
    }

    public Long getDealerOrgId() {
        return dealerOrgId;
    }

    public void setDealerOrgId(Long dealerOrgId) {
        this.dealerOrgId = dealerOrgId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getItemOrgId() {
        return itemOrgId;
    }

    public void setItemOrgId(Long itemOrgId) {
        this.itemOrgId = itemOrgId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    public BigDecimal getSupplyPrice() {
        return supplyPrice;
    }

    public void setSupplyPrice(BigDecimal supplyPrice) {
        this.supplyPrice = supplyPrice;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Integer getSyncNumber() {
        return syncNumber;
    }

    public void setSyncNumber(Integer syncNumber) {
        this.syncNumber = syncNumber;
    }

    public String getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(String supplierId) {
        this.supplierId = supplierId;
    }

    public String getThirdPartyId() {
        return thirdPartyId;
    }

    public void setThirdPartyId(String thirdPartyId) {
        this.thirdPartyId = thirdPartyId;
    }

    public String getEasNo() {
        return easNo;
    }

    public void setEasNo(String easNo) {
        this.easNo = easNo;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
}
