package com.dtyunxi.yundt.cube.center.price.dao.eo;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * PriceItemEo对象
 *
 * @author liuji
 * @since 2021-06-30
 */
@Data
@Table(name = "pr_price_item")
public class PriceItemEo extends StdPriceItemEo {
    /**
     * 0. 直接定价，1.扣率定价
     */
    @Column(name = "price_model_set_type")
    private Integer priceModelSetType;

    /**
     * 扣率类型：1.固定扣率，2.临时扣率
     */
    @Column(name = "discount_type")
    private Integer discountType;

    /**
     * 扣率值
     */
    @Column(name = "discount_rate")
    private BigDecimal discountRate;

    /**
     * 固定加价
     */
    @Column(name = "giftbox_incr_price")
    private BigDecimal giftboxIncrPrice;
}
