package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
/**
 * StdDiscountEo对象
 *
 * @author liuji
 * @since 2021-06-30
 */
public class StdDiscountEo extends CubeBaseEo {
    /**
     * 折扣编号
     */
    @Column(name = "code")
    private String code;
    /**
     * 状态（WAIT_AUDIT：待审核、AUDIT_REJECT：审核不通过、AUDIT_PASS：审核通过(待生效 、生效中、已失效)、INVALID：作废、DRAFT：草稿）
     */
    @Column(name = "status")
    private String status;
    /**
     * 名称
     */
    @Column(name = "name")
    private String name;
    /**
     * 所属组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;
    /**
     * 所属组织ID
     */
    @Column(name = "organization_id")
    private Long organizationId;
    /**
     * 生效时间
     */
    @Column(name = "effective_time")
    private Date effectiveTime;
    /**
     * 失效时间
     */
    @Column(name = "invalid_time")
    private Date invalidTime;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;
    /**
     * 折扣率
     */
    @Column(name = "discount")
    private BigDecimal discount;
    /**
     * 关联客户类型（0 指定客户、1 按客户类型、2 按客户分组、3 按客户区域）
     */
    @Column(name = "relation_customer_type")
    private String relationCustomerType;
    /**
     * 关联商户类型（0 指定商品、1 指定商品分类、2 指定商品品牌）
     */
    @Column(name = "relation_item_type")
    private String relationItemType;
    /**
     * 商品分类
     */
    @Column(name = "item_type_ids")
    private String itemTypeIds;
    /**
     * 商品品牌
     */
    @Column(name = "item_brand_ids")
    private String itemBrandIds;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public String getRelationCustomerType() {
        return relationCustomerType;
    }

    public void setRelationCustomerType(String relationCustomerType) {
        this.relationCustomerType = relationCustomerType;
    }

    public String getRelationItemType() {
        return relationItemType;
    }

    public void setRelationItemType(String relationItemType) {
        this.relationItemType = relationItemType;
    }

    public String getItemTypeIds() {
        return itemTypeIds;
    }

    public void setItemTypeIds(String itemTypeIds) {
        this.itemTypeIds = itemTypeIds;
    }

    public String getItemBrandIds() {
        return itemBrandIds;
    }

    public void setItemBrandIds(String itemBrandIds) {
        this.itemBrandIds = itemBrandIds;
    }
}