/*
 * @(#)StdPriceModelEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;



  
import javax.persistence.Table;
import javax.persistence.Column;
import java.util.Date;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 价格模型(PriceModel)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 19:08:04
 * @since v1
 */
@Data
@Table(name="pr_price_model")
public class StdPriceModelEo extends CubeBaseEo{

    /**
     * 价格大类
     */
    @Column(name = "category_code")
    private String categoryCode;
    /**
     * 价格模型名称
     */
    @Column(name = "model_name")
    private String modelName;
    /**
     * 模型编号
     */
    @Column(name = "model_code")
    private String modelCode;
    /**
     * 直接定价：0.未开启，1，开启
     */
    @Column(name = "direct_set")
    private Integer directSet;
    /**
     * '扣率定价：0-未开启，1.开启'
     */
    @Column(name = "discount_set")
    private Integer discountSet;
    /**
     * '计价公式-临时扣率：0-未开启，1.开启'
     */
    @Column(name = "temporary_discount")
    private Integer temporaryDiscount;
    /**
     * '计价公式-固定扣率：0-未开启，1.开启'
     */
    @Column(name = "fixed_discount")
    private Integer fixedDiscount;
    /**
     * 关联价格政策数
     */
    @Column(name = "related_num")
    private Integer relatedNum;
    /**
     * 状态（0：启用1：禁用）
     */
    @Column(name = "status")
    private String status;
    /**
     * 组织id
     */
    @Column(name = "organization_id")
    private Long organizationId;

    /**
     * get 价格大类
     */     
    public String getCategoryCode() {
        return categoryCode;
    }

    /**
     * set 价格大类
     */     
    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    /**
     * get 价格模型名称
     */     
    public String getModelName() {
        return modelName;
    }

    /**
     * set 价格模型名称
     */     
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    /**
     * get 模型编号
     */     
    public String getModelCode() {
        return modelCode;
    }

    /**
     * set 模型编号
     */     
    public void setModelCode(String modelCode) {
        this.modelCode = modelCode;
    }

    /**
     * get 关联价格政策数
     */     
    public Integer getRelatedNum() {
        return relatedNum;
    }

    /**
     * set 关联价格政策数
     */     
    public void setRelatedNum(Integer relatedNum) {
        this.relatedNum = relatedNum;
    }

    /**
     * get 状态（0：启用1：禁用）
     */     
    public String getStatus() {
        return status;
    }

    /**
     * set 状态（0：启用1：禁用）
     */     
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * get 组织id
     */     
    public Long getOrganizationId() {
        return organizationId;
    }

    /**
     * set 组织id
     */     
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

}
