package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * StdPriceItemEo对象
 *
 * @author liuji
 * @since 2021-06-30
 */
public class StdPriceItemEo extends CubeBaseEo {
    /**
     * 价格表id
     */
    @Column(name = "price_id")
    private Long priceId;
    /**
     * 商品id
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;
    /**
     * sku_id
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 商品规格
     */
    @Column(name = "sku_desc")
    private String skuDesc;
    /**
     * 商品规格
     */
    @Column(name = "sku_code")
    private String skuCode;
    /**
     * 成本价格
     */
    @Column(name = "cost_price")
    private BigDecimal costPrice;
    /**
     * 基准价
     */
    @Column(name = "base_price")
    private BigDecimal basePrice;
    /**
     * 价格
     */
    @Column(name = "item_price")
    private BigDecimal itemPrice;
    /**
     * 数量区间下限
     */
    @Column(name = "lower_limit")
    private Integer lowerLimit;
    /**
     * 数量区间上限
     */
    @Column(name = "upper_limit")
    private Integer upperLimit;

    /**
     * 店铺id
     */
    @Column(name = "shop_id")
    private Long shopId;

    /**
     * 所属品牌方
     */
    @Column(name = "item_org_id")
    private Long itemOrgId;

    /**
     * 商品品牌
     */
    @Column(name = "item_brand")
    private String itemBrand;

    /**
     * 是否礼盒（0：是、1：否）
     */
    @Column(name = "gift_box")
    private Integer giftBox;

    public Long getItemOrgId() {
        return itemOrgId;
    }

    public void setItemOrgId(Long itemOrgId) {
        this.itemOrgId = itemOrgId;
    }

    public String getItemBrand() {
        return itemBrand;
    }

    public void setItemBrand(String itemBrand) {
        this.itemBrand = itemBrand;
    }

    public Integer getGiftBox() {
        return giftBox;
    }

    public void setGiftBox(Integer giftBox) {
        this.giftBox = giftBox;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Long getPriceId() {
        return priceId;
    }

    public void setPriceId(Long priceId) {
        this.priceId = priceId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuDesc() {
        return skuDesc;
    }

    public void setSkuDesc(String skuDesc) {
        this.skuDesc = skuDesc;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getBasePrice() {
        return basePrice;
    }

    public void setBasePrice(BigDecimal basePrice) {
        this.basePrice = basePrice;
    }

    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public Integer getLowerLimit() {
        return lowerLimit;
    }

    public void setLowerLimit(Integer lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public Integer getUpperLimit() {
        return upperLimit;
    }

    public void setUpperLimit(Integer upperLimit) {
        this.upperLimit = upperLimit;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}