package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
/**
 * StdPriceLimitEo对象
 *
 * @author liuji
 * @since 2021-06-30
 */
public class StdPriceLimitEo extends CubeBaseEo {
    /**
     * 价格大类
     */
    @Column(name = "category_code")
    private String categoryCode;
    /**
     * 编号
     */
    @Column(name = "code")
    private String code;
    /**
     * 价盘标题
     */
    @Column(name = "name")
    private String name;
    /**
     * 所属组织ID
     */
    @Column(name = "organization_id")
    private Long organizationId;
    /**
     * 所属组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;
    /**
     * 状态（0：草稿、1：生效）
     */
    @Column(name = "status")
    private String status;
    /**
     * 生效时间
     */
    @Column(name = "effective_time")
    private Date effectiveTime;
    /**
     * 失效时间
     */
    @Column(name = "invalid_time")
    private Date invalidTime;
    /**
     * 关联客户方式（0： 指定客户、1： 按客户类型、2：不限）
     */
    @Column(name = "relation_customer_type")
    private Integer relationCustomerType;

    /**
     * 适用商品（0： 指定商品、1： 指定品类、2：不限）
     */
    @Column(name = "relation_item_type")
    private Integer relationItemType;

    /**
     *  价格下限：（relationItemType<>0 时的商品价格下限)
     */
    @Column(name = "lower_limit")
    private BigDecimal lowerLimit ;
    /**
     *  价格上限：（relationItemType<>0 时的商品价格上限)
     */
    @Column(name = "upper_limit")
    private BigDecimal upperLimit ;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 原价盘编号
     */
    @Column(name = "original_limit_code")
    private String originalLimitCode;

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public Integer getRelationCustomerType() {
        return relationCustomerType;
    }

    public void setRelationCustomerType(Integer relationCustomerType) {
        this.relationCustomerType = relationCustomerType;
    }

    public Integer getRelationItemType() {
        return relationItemType;
    }

    public void setRelationItemType(Integer relationItemType) {
        this.relationItemType = relationItemType;
    }

    public BigDecimal getLowerLimit() {
        return lowerLimit;
    }

    public void setLowerLimit(BigDecimal lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public BigDecimal getUpperLimit() {
        return upperLimit;
    }

    public void setUpperLimit(BigDecimal upperLimit) {
        this.upperLimit = upperLimit;
    }

    public String getOriginalLimitCode() {
        return originalLimitCode;
    }

    public void setOriginalLimitCode(String originalLimitCode) {
        this.originalLimitCode = originalLimitCode;
    }
}