/*
 * @(#)StdPriceRejectCustomerEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;



  
import javax.persistence.Table;
import javax.persistence.Column;
import java.util.Date;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import java.math.BigDecimal;

/**
 * 剔除客户明细(PriceRejectCustomer)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 19:30:02
 * @since v1
 */
@Table(name="pr_price_reject_customer")
public class StdPriceRejectCustomerEo extends CubeBaseEo{

    /**
     * 价格表id/折扣表id/价盘表id
     */
    @Column(name = "relate_id")
    private Long relateId;
    /**
     * 关联类型（0：价格表1：折扣表2：价盘表）
     */
    @Column(name = "relate_type")
    private String relateType;
    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private Long customerId;
    /**
     * 客户编码
     */
    @Column(name = "customer_code")
    private String customerCode;
    /**
     * 客户名字
     */
    @Column(name = "customer_name")
    private String customerName;


    /**
     * get 价格表id/折扣表id/价盘表id
     */     
    public Long getRelateId() {
        return relateId;
    }

    /**
     * set 价格表id/折扣表id/价盘表id
     */     
    public void setRelateId(Long relateId) {
        this.relateId = relateId;
    }

    /**
     * get 关联类型（0：价格表1：折扣表2：价盘表）
     */     
    public String getRelateType() {
        return relateType;
    }

    /**
     * set 关联类型（0：价格表1：折扣表2：价盘表）
     */     
    public void setRelateType(String relateType) {
        this.relateType = relateType;
    }

    /**
     * get 客户id
     */     
    public Long getCustomerId() {
        return customerId;
    }

    /**
     * set 客户id
     */     
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    /**
     * get 客户编码
     */     
    public String getCustomerCode() {
        return customerCode;
    }

    /**
     * set 客户编码
     */     
    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    /**
     * get 客户名字
     */     
    public String getCustomerName() {
        return customerName;
    }

    /**
     * set 客户名字
     */     
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

}
