package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;

/**
 * StdPriceTypeEo对象
 *
 * @author liuji
 * @since 2021-06-30
 */
public class StdPriceTypeEo extends CubeBaseEo {
    /**
     * 价格大类
     */
    @Column(name = "category_code")
    private String categoryCode;
    /**
     * 价格类型名称
     */
    @Column(name = "type_name")
    private String typeName;
    /**
     * 价格类型编码
     */
    @Column(name = "type_code")
    private String typeCode;
    /**
     * 状态（0：启用1：禁用）
     */
    @Column(name = "status")
    private String status;
    /**
     * 优先级（1-100，值越小，优先级越高）
     */
    @Column(name = "weight")
    private String weight;
    /**
     * 所属组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;
    /**
     * 所属组织ID
     */
    @Column(name = "organization_id")
    private Long organizationId;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;
    /**
     * 基础价设置方式（0.品牌方设置，1.经销商设置）
     */
    @Column(name = "setting_mode")
    private Integer settingMode;
    /**
     * 关联价格政策数
     */
    @Column(name = "related_num")
    private Integer relatedNum;

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public Integer getSettingMode() {
        return settingMode;
    }

    public void setSettingMode(Integer settingMode) {
        this.settingMode = settingMode;
    }

    public Integer getRelatedNum() {
        return relatedNum;
    }

    public void setRelatedNum(Integer relatedNum) {
        this.relatedNum = relatedNum;
    }
}