/*
 * @(#)StdBasePriceApplyItemEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;
import java.math.BigDecimal;



  
import javax.persistence.Table;
import javax.persistence.Column;
import java.util.Date;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import java.math.BigDecimal;

/**
 * 基础价调价申请商品明细(BasePriceApplyItem)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 13:56:06
 * @since v1
 */
@Table(name="pr_base_price_apply_item")
public class StdBasePriceApplyItemEo extends CubeBaseEo{

    /**
     * 商品所属组织id
     */
    @Column(name = "item_org_id")
    private Long itemOrgId;
    /**
     * 价格
     */
    @Column(name = "item_price")
    private BigDecimal itemPrice;
    /**
     * sku编码
     */
    @Column(name = "sku_code")
    private String skuCode;
    /**
     * 品牌
     */
    @Column(name = "item_brand")
    private String itemBrand;
    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;
    /**
     * 价格类型id
     */
    @Column(name = "type_id")
    private Long typeId;
    /**
     * 规格
     */
    @Column(name = "sku_spec")
    private String skuSpec;
    /**
     * 是否礼盒（0：是、1：否）
     */
    @Column(name = "gift_box")
    private Integer giftBox;
    /**
     * 商品编码
     */
    @Column(name = "item_code")
    private String itemCode;
    /**
     * 调价申请单
     */
    @Column(name = "apply_id")
    private Long applyId;
    /**
     * 商品id
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * skuId
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 组织id
     */
    @Column(name = "organization_id")
    private Long organizationId;
    /**
     * 商品主图
     */
    @Column(name = "item_pic")
    private String itemPic;
    /**
     * 商品所属组织名字
     */
    @Column(name = "item_org_name")
    private String itemOrgName;
    /**
     * 单位
     */
    @Column(name = "unit_name")
    private String unitName;
    /**
     * 商品子类型，1-产品，2-赠品，3-物料
     */
    @Column(name = "sub_type")
    private Integer subType;


    /**
     * get 商品所属组织id
     */     
    public Long getItemOrgId() {
        return itemOrgId;
    }

    /**
     * set 商品所属组织id
     */     
    public void setItemOrgId(Long itemOrgId) {
        this.itemOrgId = itemOrgId;
    }

    /**
     * get 价格
     */     
    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    /**
     * set 价格
     */     
    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    /**
     * get sku编码
     */     
    public String getSkuCode() {
        return skuCode;
    }

    /**
     * set sku编码
     */     
    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    /**
     * get 品牌
     */     
    public String getItemBrand() {
        return itemBrand;
    }

    /**
     * set 品牌
     */     
    public void setItemBrand(String itemBrand) {
        this.itemBrand = itemBrand;
    }

    /**
     * get 商品名称
     */     
    public String getItemName() {
        return itemName;
    }

    /**
     * set 商品名称
     */     
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * get 价格类型id
     */     
    public Long getTypeId() {
        return typeId;
    }

    /**
     * set 价格类型id
     */     
    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    /**
     * get 规格
     */     
    public String getSkuSpec() {
        return skuSpec;
    }

    /**
     * set 规格
     */     
    public void setSkuSpec(String skuSpec) {
        this.skuSpec = skuSpec;
    }

    /**
     * get 是否礼盒（0：是、1：否）
     */     
    public Integer getGiftBox() {
        return giftBox;
    }

    /**
     * set 是否礼盒（0：是、1：否）
     */     
    public void setGiftBox(Integer giftBox) {
        this.giftBox = giftBox;
    }

    /**
     * get 商品编码
     */     
    public String getItemCode() {
        return itemCode;
    }

    /**
     * set 商品编码
     */     
    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    /**
     * get 调价申请单
     */     
    public Long getApplyId() {
        return applyId;
    }

    /**
     * set 调价申请单
     */     
    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    /**
     * get 商品id
     */     
    public Long getItemId() {
        return itemId;
    }

    /**
     * set 商品id
     */     
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    /**
     * get skuId
     */     
    public Long getSkuId() {
        return skuId;
    }

    /**
     * set skuId
     */     
    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    /**
     * get 组织id
     */     
    public Long getOrganizationId() {
        return organizationId;
    }

    /**
     * set 组织id
     */     
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    /**
     * get 商品主图
     */     
    public String getItemPic() {
        return itemPic;
    }

    /**
     * set 商品主图
     */     
    public void setItemPic(String itemPic) {
        this.itemPic = itemPic;
    }

    /**
     * get 商品所属组织名字
     */     
    public String getItemOrgName() {
        return itemOrgName;
    }

    /**
     * set 商品所属组织名字
     */     
    public void setItemOrgName(String itemOrgName) {
        this.itemOrgName = itemOrgName;
    }

    /**
     * get 单位
     */     
    public String getUnitName() {
        return unitName;
    }

    /**
     * set 单位
     */     
    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    /**
     * get 商品子类型，1-产品，2-赠品，3-物料
     */     
    public Integer getSubType() {
        return subType;
    }

    /**
     * set 商品子类型，1-产品，2-赠品，3-物料
     */     
    public void setSubType(Integer subType) {
        this.subType = subType;
    }

}
