/*
 * @(#)StdPriceExcelTemplateEo.java 1.0 2021-12-15
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;


import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 导入导出模板(PriceExcelTemplate)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-12-15 16:21:06
 * @since v1
 */
@Table(name="pr_price_excel_template")
public class StdPriceExcelTemplateEo extends CubeBaseEo{

    /**
     * 唯一编码
     */
    @Column(name = "code")
    private String code;
    /**
     * 模板名字
     */
    @Column(name = "name")
    private String name;
    /**
     * 模板配置信息
     */
    @Column(name = "config")
    private String config;
    /**
     * 已有的模板url，优先获取该模板，没有的话则根据配置信息动态生成
     */
    @Column(name = "url")
    private String url;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;


    /**
     * get 唯一编码
     */     
    public String getCode() {
        return code;
    }

    /**
     * set 唯一编码
     */     
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * get 模板名字
     */     
    public String getName() {
        return name;
    }

    /**
     * set 模板名字
     */     
    public void setName(String name) {
        this.name = name;
    }

    /**
     * get 模板配置信息
     */     
    public String getConfig() {
        return config;
    }

    /**
     * set 模板配置信息
     */     
    public void setConfig(String config) {
        this.config = config;
    }

    /**
     * get 已有的模板url，优先获取该模板，没有的话则根据配置信息动态生成
     */     
    public String getUrl() {
        return url;
    }

    /**
     * set 已有的模板url，优先获取该模板，没有的话则根据配置信息动态生成
     */     
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * get 备注
     */     
    public String getRemark() {
        return remark;
    }

    /**
     * set 备注
     */     
    public void setRemark(String remark) {
        this.remark = remark;
    }

}
