package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import java.util.Date;

/**
 * StdAuditEo对象
 *
 * @author liuji
 * @since 2021-06-30
 */
public class StdAuditEo extends CubeBaseEo {
    /**
     * 审核人
     */
    @Column(name = "audit_person")
    private String auditPerson;
    /**
     * 审核时间
     */
    @Column(name = "audit_time")
    private Date auditTime;
    /**
     * 审核意见
     */
    @Column(name = "audit_comments")
    private String auditComments;
    /**
     * 价格表id/折扣表id/价盘表id
     */
    @Column(name = "relate_id")
    private Long relateId;
    /**
     * 关联类型（0：价格表1：折扣表2：价盘表）
     */
    @Column(name = "relate_type")
    private String relateType;
    /**
     * 关联的id对应的状态，用于查询关联主表的最新一条审核记录时，判断是否是主表的状态的审核记录
     */
    @Column(name = "audit_status")
    private String auditStatus;

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(String auditPerson) {
        this.auditPerson = auditPerson;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public String getAuditComments() {
        return auditComments;
    }

    public void setAuditComments(String auditComments) {
        this.auditComments = auditComments;
    }

    public Long getRelateId() {
        return relateId;
    }

    public void setRelateId(Long relateId) {
        this.relateId = relateId;
    }

    public String getRelateType() {
        return relateType;
    }

    public void setRelateType(String relateType) {
        this.relateType = relateType;
    }
}