/*
 * @(#)StdBasePriceApplyEo.java 1.0 2021-11-18
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 基础价调价申请(BasePriceApply)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-18 13:55:39
 * @since v1
 */
@Table(name="pr_base_price_apply")
public class StdBasePriceApplyEo extends CubeBaseEo{

    /**
     * 申请单编号
     */
    @Column(name = "apply_code")
    private String applyCode;
    /**
     * 申请单标题
     */
    @Column(name = "apply_name")
    private String applyName;
    /**
     * 适用店铺
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 关联sku数量（冗余关联查询到的商品sku统计数量）
     */
    @Column(name = "sku_num")
    private Integer skuNum;
    /**
     * 生效时间
     */
    @Column(name = "effect_time")
    private Date effectTime;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;
    /**
     * 状态，（枚举：WAIT_AUDIT-待审核；AUDIT_REJECT-审核不通过；AUDIT_PASS-审核通过(待生效 、生效中、已失效)；INVALID-作废，DRAFT-草稿）
     */
    @Column(name = "status")
    private String status;
    /**
     * 组织id
     */
    @Column(name = "organization_id")
    private Long organizationId;
    /**
     * 同步状态，（0-待同步，1-已同步）
     */
    @Column(name = "sync_status")
    private Integer syncStatus;

    public Integer getSyncStatus() {
        return syncStatus;
    }

    public void setSyncStatus(Integer syncStatus) {
        this.syncStatus = syncStatus;
    }

    /**
     * get 申请单编号
     */     
    public String getApplyCode() {
        return applyCode;
    }

    /**
     * set 申请单编号
     */     
    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }

    /**
     * get 申请单标题
     */     
    public String getApplyName() {
        return applyName;
    }

    /**
     * set 申请单标题
     */     
    public void setApplyName(String applyName) {
        this.applyName = applyName;
    }

    /**
     * get 适用店铺
     */     
    public Long getShopId() {
        return shopId;
    }

    /**
     * set 适用店铺
     */     
    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    /**
     * get 关联sku数量（冗余关联查询到的商品sku统计数量）
     */     
    public Integer getSkuNum() {
        return skuNum;
    }

    /**
     * set 关联sku数量（冗余关联查询到的商品sku统计数量）
     */     
    public void setSkuNum(Integer skuNum) {
        this.skuNum = skuNum;
    }

    /**
     * get 生效时间
     */     
    public Date getEffectTime() {
        return effectTime;
    }

    /**
     * set 生效时间
     */     
    public void setEffectTime(Date effectTime) {
        this.effectTime = effectTime;
    }

    /**
     * get 备注
     */     
    public String getRemark() {
        return remark;
    }

    /**
     * set 备注
     */     
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * get 状态，（枚举：WAIT_AUDIT-待审核；AUDIT_REJECT-审核不通过；AUDIT_PASS-审核通过(待生效 、生效中、已失效)；INVALID-作废，DRAFT-草稿）
     */     
    public String getStatus() {
        return status;
    }

    /**
     * set 状态，（枚举：WAIT_AUDIT-待审核；AUDIT_REJECT-审核不通过；AUDIT_PASS-审核通过(待生效 、生效中、已失效)；INVALID-作废，DRAFT-草稿）
     */     
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * get 组织id
     */
    public Long getOrganizationId() {
        return organizationId;
    }

    /**
     * set 组织id
     */
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

}
