package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 价盘客户明细Eo对象
 *
 * @author author
 * @since 2021-11-25
 */
@Table(name = "pr_limit_customer")
public class StdLimitCustomerEo extends CubeBaseEo {
    /**
     * 价格表id/折扣表id/价盘表id
     */
    @Column(name = "relate_id")
    private Long relateId;
    /**
     * 关联类型（0：价格表1：折扣表2：价盘表）
     */
    @Column(name = "relate_type")
    private String relateType;
    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private Long customerId;
    /**
     * 客户编码
     */
    @Column(name = "customer_code")
    private String customerCode;
    /**
     * 客户名字
     */
    @Column(name = "customer_name")
    private String customerName;
    /**
     * 商家id
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 商家名称
     */
    @Column(name = "shop_name")
    private String shopName;

    public void setRelateId(Long relateId) {
        this.relateId = relateId;
    }

    public Long getRelateId() {
        return this.relateId;
    }

    public void setRelateType(String relateType) {
        this.relateType = relateType;
    }

    public String getRelateType() {
        return this.relateType;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }
}
