package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * StdLimitItemEo对象
 *
 * @author liuji
 * @since 2021-06-30
 */
public class StdLimitItemEo extends CubeBaseEo {
    /**
     * 价盘id
     */
    @Column(name = "price_limit_id")
    private Long priceLimitId;
    /**
     * 商品id
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;
    /**
     * skuid
     */
    @Column(name = "sku_id")
    private Long skuId;

    /**
     * skuCode
     */
    @Column(name = "sku_code")
    private String skuCode;


    /**
     * 商品规格
     */
    @Column(name = "sku_desc")
    private String skuDesc;
    /**
     * 价格下限
     */
    @Column(name = "lower_limit")
    private BigDecimal lowerLimit;
    /**
     * 价格上限
     */
    @Column(name = "upper_limit")
    private BigDecimal upperLimit;
    /**
     * 管控强度类型（0：强管控1：弱管控）
     */
    @Column(name = "control_type")
    private String controlType;

    /**
     * 店铺id
     */
    @Column(name = "shop_id")
    private Long shopId;

    /**
     * 商品编码
     */
    @Column(name = "item_code")
    private String itemCode;

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Long getPriceLimitId() {
        return priceLimitId;
    }

    public void setPriceLimitId(Long priceLimitId) {
        this.priceLimitId = priceLimitId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuDesc() {
        return skuDesc;
    }

    public void setSkuDesc(String skuDesc) {
        this.skuDesc = skuDesc;
    }

    public BigDecimal getLowerLimit() {
        return lowerLimit;
    }

    public void setLowerLimit(BigDecimal lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public BigDecimal getUpperLimit() {
        return upperLimit;
    }

    public void setUpperLimit(BigDecimal upperLimit) {
        this.upperLimit = upperLimit;
    }

    public String getControlType() {
        return controlType;
    }

    public void setControlType(String controlType) {
        this.controlType = controlType;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }
}