/*
 * @(#)StdPriceBasicConfigEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;



  
import javax.persistence.Table;
import javax.persistence.Column;
import java.util.Date;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import java.math.BigDecimal;

/**
 * 基础设置(PriceBasicConfig)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 19:28:26
 * @since v1
 */
@Table(name="pr_price_basic_config")
public class StdPriceBasicConfigEo extends CubeBaseEo{

    /**
     * 设置类型（0：基础设置、1：价盘设置）
     */
    @Column(name = "config_type")
    private Integer configType;
    /**
     * 管控方式（0：管控1：提醒）
     */
    @Column(name = "control_type")
    private Integer controlType;
    /**
     * 取价规则—不同维度（默认为0 按最细维度）
     */
    @Column(name = "rule_diff_dim")
    private Integer ruleDiffDim;
    /**
     * 取价规则—相同维度（0：不允许相同维度、1：按创建最近时间）
     */
    @Column(name = "rule_same_dim")
    private Integer ruleSameDim;
    /**
     * 组织id
     */
    @Column(name = "organization_id")
    private Long organizationId;
    /**
     * 价格大类（扩展字段，用于区分属于哪个价格大类）
     */
    @Column(name = "category_code")
    private String categoryCode;


    /**
     * get 设置类型（0：基础设置、1：价盘设置）
     */     
    public Integer getConfigType() {
        return configType;
    }

    /**
     * set 设置类型（0：基础设置、1：价盘设置）
     */     
    public void setConfigType(Integer configType) {
        this.configType = configType;
    }

    /**
     * get 管控方式（0：管控1：提醒）
     */     
    public Integer getControlType() {
        return controlType;
    }

    /**
     * set 管控方式（0：管控1：提醒）
     */     
    public void setControlType(Integer controlType) {
        this.controlType = controlType;
    }

    /**
     * get 取价规则—不同维度（默认为0 按最细维度）
     */     
    public Integer getRuleDiffDim() {
        return ruleDiffDim;
    }

    /**
     * set 取价规则—不同维度（默认为0 按最细维度）
     */     
    public void setRuleDiffDim(Integer ruleDiffDim) {
        this.ruleDiffDim = ruleDiffDim;
    }

    /**
     * get 取价规则—相同维度（0：不允许相同维度、1：按创建最近时间）
     */     
    public Integer getRuleSameDim() {
        return ruleSameDim;
    }

    /**
     * set 取价规则—相同维度（0：不允许相同维度、1：按创建最近时间）
     */     
    public void setRuleSameDim(Integer ruleSameDim) {
        this.ruleSameDim = ruleSameDim;
    }

    /**
     * get 组织id
     */     
    public Long getOrganizationId() {
        return organizationId;
    }

    /**
     * set 组织id
     */     
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    /**
     * get 价格大类（扩展字段，用于区分属于哪个价格大类）
     */     
    public String getCategoryCode() {
        return categoryCode;
    }

    /**
     * set 价格大类（扩展字段，用于区分属于哪个价格大类）
     */     
    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

}
