/*
 * @(#)IGiftBalanceAdvanceApi.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceAdvanceAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceExcelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：预支额度"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftBalanceAdvanceApi",
    name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
    url = "${yundt-cube-center-rebate_api:}",
    path = "/v1/gift/balance-advance")
public interface IGiftBalanceAdvanceApi {

  @PutMapping(value = "add", produces = "application/json")
  @ApiOperation(value = "预支额度新增", notes = "预支额度新增")
  RestResponse<Void> add(@Valid @RequestBody BalanceAdvanceAddReqDto addReqDto);

  @DeleteMapping(value = "delete/{id}", produces = "application/json")
  @ApiOperation(value = "预支额度删除", notes = "预支额度删除")
  RestResponse<Void> delete(@Valid @PathVariable("id") Long id);

  @PostMapping(value = "/excel", produces = "application/json")
  @ApiOperation(value = "额度Excel导入", notes = "额度Excel导入")
  RestResponse<GiftBalanceExcelRespDto> excel(@RequestParam("file") MultipartFile file);
}
