package com.dtyunxi.yundt.cube.center.rebate.api.gift;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.*;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceExcelRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalancePayRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：赠品余额"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftBalanceApi",
        name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
        url = "${yundt-cube-center-rebate_api:}",
        path = "/v1/gift/balance"
)
public interface IGiftBalanceApi {

    @PutMapping(value = "/setting", produces = "application/json")
    @ApiOperation(value = "账户配置", notes = "账户配置")
    RestResponse<Void> setting(@Valid @RequestBody GiftBalanceSettingReqDto settingReqDto);


    @PutMapping(value = "add", produces = "application/json")
    @ApiOperation(value = "新增账户", notes = "新增账户")
    RestResponse<Void> add(@Valid @RequestBody GiftBalanceAddReqDto settingReqDto);


    /**
     * 使用返利
     *
     * @return 处理结果
     */
    @PostMapping("/use")
    @ApiOperation(value = "使用返利支付", notes = "使用返利支付")
    RestResponse<GiftBalancePayRespDto> useBalance(@RequestBody GiftBalancePayReqDto reqDto);

    /**
     * 返利退回
     *
     * @return 处理结果
     */
    @PostMapping("/return")
    @ApiOperation(value = "返利退回", notes = "返利退回")
    RestResponse<GiftBalancePayRespDto> returnBalance(@Valid @RequestBody GiftBalanceReturnReqDto reqDto);

    /**
     * 修改额度
     *
     * @param modifyReqDto
     * @return
     */
    @PutMapping(value = "modify", produces = "application/json")
    @ApiOperation(value = "修改账号余额、冻结额度、可用额度，参数为增量或者减量数据 ", notes = "修改账号余额、冻结额度、可用额度，参数为增量或者减量数据")
    RestResponse<Void> modify(@RequestBody GiftBalanceModifyReqDto modifyReqDto);

    /**
     * 修改额度
     *
     * @param balanceRelModifyReqDto
     * @return
     */
    @PostMapping(value = "modifyBalanceRel", produces = "application/json")
    @ApiOperation(value = "提交订单对免费赠品额度的操作 ", notes = "提交订单对免费赠品额度的操作")
    RestResponse<Void> modifyBalanceRel(@RequestBody BalanceRelModifyReqDto balanceRelModifyReqDto);

    @PostMapping(value = "release", produces = "application/json")
    @ApiOperation(value = "释放订单冻结的额度 ", notes = "释放订单冻结的额度")
    RestResponse<Void> release(@RequestParam("orderNo") String orderNo);

    @PostMapping(value = "/excel", produces = "application/json")
    @ApiOperation(value = "额度Excel导入", notes = "额度Excel导入")
    RestResponse<GiftBalanceExcelRespDto> excel(@RequestParam("file") MultipartFile file);

    /**
     * 手工调整免费赠品额度
     *
     * @param adjustGiftBalanceReqDto
     * @return
     */
    @PostMapping(value = "/adjustGiftBalance")
    @ApiOperation(value = "手工调整免费赠品额度", notes = "手工调整免费赠品额度")
    RestResponse<Void> adjustGiftBalance(@Valid @RequestBody AdjustGiftBalanceReqDto adjustGiftBalanceReqDto);

    /**
     * 导入调整免费赠品额度
     *
     * @param excelAdjustReqDto
     * @return
     */
    @PostMapping(value = "/adjustGiftBalance/excel")
    @ApiOperation(value = "导入调整免费赠品额度", notes = "导入调整免费赠品额度")
    RestResponse<GiftBalanceExcelRespDto> excelAdjust(@RequestBody @Valid ExcelAdjustReqDto excelAdjustReqDto);
}
