/*
 * @(#)IGiftBalanceFreezeApi.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceFreezeAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceFreezeModifyReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：冻结额度"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftBalanceFreezeApi",
        name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
        url = "${yundt-cube-center-rebate_api:}",
        path = "/v1/gift/balance-freeze"
)
public interface IGiftBalanceFreezeApi {

    @PutMapping(value = "add", produces = "application/json")
    @ApiOperation(value = "冻结额度新增", notes = "冻结额度新增")
    RestResponse<Void> add(@Valid @RequestBody BalanceFreezeAddReqDto addReqDto );

    @PutMapping(value = "modify/unFreeze", produces = "application/json")
    @ApiOperation(value = "冻结额度解冻", notes = "冻结额度解冻")
    RestResponse<Void> modifyUnFreeze(@Valid @RequestBody BalanceFreezeModifyReqDto modifyReqDto );

}
