/*
 * @(#)IGiftBalanceRecordApi.java 1.0 2021年09月19日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.rebate.api.gift;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceRecordAddReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：赠送记录"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftBalanceRecordApi",
    name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
    url = "${yundt-cube-center-rebate_api:}",
    path = "/v1/gift/balance-record")
public interface IGiftBalanceRecordApi {

  @PutMapping(value = "add", produces = "application/json")
  @ApiOperation(value = "新增赠送记录", notes = "新增赠送记录")
  RestResponse<Void> add(@Valid @RequestBody BalanceRecordAddReqDto addReqDto);
}
