package com.dtyunxi.yundt.cube.center.rebate.api.gift;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftConfigBaseReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftConfigExcludeReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftBalanceExcelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.util.List;

/**
 * @author 即墨
 * @version 1.0.0
 */
@Api(tags = {"赠品额度：赠品总控配置"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftConfigApi",
        name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
        url = "${yundt-cube-center-rebate_api:}",
        path = "/v1/gift-config"
)
public interface IGiftConfigApi {


    @PutMapping("/base/add")
    @ApiOperation(value = "基础配置", notes = "基础配置")
    RestResponse<Void> addBase(@RequestBody @Valid GiftConfigBaseReqDto baseReqDto);


    @PutMapping("/sku/exclude/add")
    @ApiOperation(value = "商品排除", notes = "基础配置")
    RestResponse<Void> exclude(@RequestBody @Valid GiftConfigExcludeReqDto excludeReqDto);

    @PutMapping("/sku/exclude/batchAdd")
    @ApiOperation(value = "批量商品排除", notes = "基础配置-批量商品排除")
    RestResponse<Void> batchExclude(@RequestBody @Valid List<GiftConfigExcludeReqDto> excludeReqDtoList);

    @PostMapping(value = "/sku/exclude/excel", produces = "application/json")
    @ApiOperation(value = "商品排除Excel导入", notes = "商品排除Excel导入")
    RestResponse<GiftBalanceExcelRespDto> excel(@RequestParam("file") MultipartFile file);
}
