package com.dtyunxi.yundt.cube.center.rebate.api.gift;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.GiftConfigCustomerExcludeReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.ItemSkuCustomerExcelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.util.List;

@Api(tags = {"赠品额度：赠品总控配置"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-rebate-api-gift-IGiftConfigCustomerApi",
        name = "${yundt-cube-center-rebate_api.name:yundt-cube-center-rebate}",
        url = "${yundt-cube-center-rebate_api:}",
        path = "/v1/gift-config-customer"
)
public interface IGiftConfigCustomerApi {

    @PutMapping("/sku/exclude/add")
    @ApiOperation(value = "商品排除", notes = "基础配置")
    RestResponse<Void> exclude(@RequestBody @Valid List<GiftConfigCustomerExcludeReqDto> excludeReqDtoList);

    @PostMapping(value = "/excel", produces = "application/json")
    @ApiOperation(value = "Excel导入排除", notes = "Excel导入排除")
    RestResponse<ItemSkuCustomerExcelRespDto> excel(MultipartFile file);
}
