package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant;

/**
 * 产品折让后金额
 * @author 即墨
 * Date 2021-09-01
 */
public enum AfterDiscountAmountEnum {

    /**
     * 产品折让后金额
     */
    EXCLUDE_PROMOTION("EXCLUDE_PROMOTION", "产品金额（不包含赠品和物料）- 促销优惠金额"),
    EXCLUDE_REBATE("EXCLUDE_REBATE", "产品金额（不包含赠品和物料）- 折扣账户抵扣金额"),
    EXCLUDE_PROMOTION_REBATE("EXCLUDE_REBATE_PROMOTION", "产品金额（不包含赠品和物料）- 促销优惠金额 - 折扣账户抵扣金额"),
    ;

    private final String code;
    private final String name;

    AfterDiscountAmountEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static AfterDiscountAmountEnum fromCode(String code) {
        for (AfterDiscountAmountEnum typeEnum : AfterDiscountAmountEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        AfterDiscountAmountEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        AfterDiscountAmountEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public String toName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


}
