package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant;

/**
 * 抵扣方式
 * @author 即墨
 * Date 2021-08-31
 */
public enum GiftConfigRangeEnum {

    /**
     * 交易类型
     */
    RANGE_FRIST("01", "满减/满折活动立减/折扣金额"),
    RANGE_SECTION("02", "满赠活动产品金额"),
    RANGE_THREE("03", "折扣账户抵扣金额"),
    ;

    private final String code;
    private final String name;

    GiftConfigRangeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static GiftConfigRangeEnum fromCode(String code) {
        for (GiftConfigRangeEnum typeEnum : GiftConfigRangeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        GiftConfigRangeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        GiftConfigRangeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public String toName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
