package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant;

/**
 * 赠品配置枚举
 *
 * @author 即墨 Date 2021-08-31
 */
public enum GiftConfigTypeEnum {

  /** 交易类型 */
  PART_DEDUCT("01", "部分抵扣（可抵扣赠品售价的部分金额）"),
  ALL_DEDUCT("02", "全抵扣（赠品售价多少必须抵扣多少）"),
  ;

  private final String code;
  private final String name;

  GiftConfigTypeEnum(String code, String name) {
    this.code = code;
    this.name = name;
  }

  public static GiftConfigTypeEnum fromCode(String code) {
    for (GiftConfigTypeEnum typeEnum : GiftConfigTypeEnum.values()) {
      if (typeEnum.getCode().equals(code)) {
        return typeEnum;
      }
    }
    return null;
  }

  public static String toCode(String status) {
    GiftConfigTypeEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getCode();
  }

  public static String toName(String status) {
    GiftConfigTypeEnum newEnum = fromCode(status);
    return newEnum == null ? null : newEnum.getName();
  }

  public String toName() {
    return name;
  }

  public String getCode() {
    return code;
  }

  public String getName() {
    return name;
  }
}
