package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant;

/**
 * 赠品排除
 * @author 即墨
 * Date 2021-09-03
 */
public enum GiftExcludeEnum {

    /**
     * 赠品排除
     */
    NOT_EXCLUDE(0, "未排除"),
    EXCLUDE(1, "已排除"),
    ALL(3, "全部"),
    ;

    private final Integer code;
    private final String name;

    GiftExcludeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static GiftExcludeEnum fromCode(Integer code) {
        for (GiftExcludeEnum typeEnum : GiftExcludeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }



    public static String toName(Integer code) {
        GiftExcludeEnum newEnum = fromCode(code);
        return newEnum == null ? null : newEnum.getName();
    }

    public String toName() {
        return name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
