package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant;

/**
 * 赠送金额类型
 * @author 即墨
 * Date 2021-08-31
 */
public enum GivePriceTypeEnum {

    /**
     * 赠送金额类型
     */
    ORIGINAL_PRICE("01", "产品金额"),
    DISCOUNT_PRICE("02", "产品折让后金额"),
    ;

    private final String code;
    private final String name;

    GivePriceTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static GivePriceTypeEnum fromName(String name) {
        for (GivePriceTypeEnum typeEnum : GivePriceTypeEnum.values()) {
            if (typeEnum.getName().equals(name)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static GivePriceTypeEnum fromCode(String code) {
        for (GivePriceTypeEnum typeEnum : GivePriceTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        GivePriceTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        GivePriceTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public static String nameToCode(String name) {
        GivePriceTypeEnum newEnum = fromName(name);
        return newEnum == null ? null : newEnum.getCode();
    }


    public String toName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
