package com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant;

/**
 * 赠送类型
 * @author 即墨
 * Date 2021-08-31
 */
public enum GiveTypeEnum {

    /**
     * 赠送类型
     */
    AMOUNT_OF_MONEY("01", "按下单金额比例赠送"),
    PROPORTION("02", "按下单数量比例赠送"),
    ;

    private final String code;
    private final String name;

    GiveTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static GiveTypeEnum fromCode(String code) {
        for (GiveTypeEnum typeEnum : GiveTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static GiveTypeEnum fromName(String name) {
        for (GiveTypeEnum typeEnum : GiveTypeEnum.values()) {
            if (typeEnum.getName().equals(name)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        GiveTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        GiveTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public static String nameToCode(String name){
        GiveTypeEnum newEnum = fromName(name);
        return newEnum == null ? null : newEnum.getCode();
    }

    public String toName() {
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
